/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.oauth2.entities.impl;

import com.jagrosh.jdautilities.oauth2.OAuth2Client;
import com.jagrosh.jdautilities.oauth2.entities.OAuth2Guild;
import java.util.EnumSet;
import net.dv8tion.jda.api.Permission;

public class OAuth2GuildImpl
implements OAuth2Guild {
    private final OAuth2Client client;
    private final long id;
    private final String name;
    private final String icon;
    private final boolean owner;
    private final int permissions;

    public OAuth2GuildImpl(OAuth2Client client, long id, String name, String icon, boolean owner, int permissions) {
        this.client = client;
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.owner = owner;
        this.permissions = permissions;
    }

    @Override
    public OAuth2Client getClient() {
        return this.client;
    }

    public long getIdLong() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIconId() {
        return this.icon;
    }

    @Override
    public String getIconUrl() {
        return this.icon == null ? null : "https://cdn.discordapp.com/icons/" + this.id + "/" + this.icon + ".png";
    }

    @Override
    public int getPermissionsRaw() {
        return this.permissions;
    }

    @Override
    public EnumSet<Permission> getPermissions() {
        return Permission.getPermissions((long)this.permissions);
    }

    @Override
    public boolean isOwner() {
        return this.owner;
    }

    @Override
    public boolean hasPermission(Permission ... perms) {
        if (this.isOwner()) {
            return true;
        }
        long adminPermRaw = Permission.ADMINISTRATOR.getRawValue();
        int permissions = this.getPermissionsRaw();
        if (((long)permissions & adminPermRaw) == adminPermRaw) {
            return true;
        }
        long checkPermsRaw = Permission.getRaw((Permission[])perms);
        return ((long)permissions & checkPermsRaw) == checkPermsRaw;
    }
}

