/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.oauth2.requests;

import com.jagrosh.jdautilities.oauth2.entities.impl.OAuth2ClientImpl;
import com.jagrosh.jdautilities.oauth2.requests.OAuth2Requester;
import java.io.IOException;
import java.util.function.Consumer;
import javax.annotation.WillClose;
import net.dv8tion.jda.internal.requests.Method;
import net.dv8tion.jda.internal.utils.Checks;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class OAuth2Action<T> {
    protected static final Consumer DEFAULT_SUCCESS = t -> {};
    protected static final Consumer<Throwable> DEFAULT_FAILURE = t -> OAuth2Requester.LOGGER.error("Requester encountered an error while processing response!");
    protected final OAuth2ClientImpl client;
    protected final Method method;
    protected final String url;

    public OAuth2Action(OAuth2ClientImpl client, Method method, String url) {
        Checks.notNull((Object)client, (String)"OAuth2Client");
        Checks.notNull((Object)method, (String)"Request method");
        Checks.notEmpty((CharSequence)url, (String)"URL");
        this.client = client;
        this.method = method;
        this.url = url;
    }

    protected RequestBody getBody() {
        return OAuth2Requester.EMPTY_BODY;
    }

    protected Headers getHeaders() {
        return Headers.of((String[])new String[0]);
    }

    protected Request buildRequest() {
        Request.Builder builder = new Request.Builder();
        switch (this.method) {
            case GET: {
                builder.get();
                break;
            }
            case POST: {
                builder.post(this.getBody());
                break;
            }
            default: {
                throw new IllegalArgumentException(this.method.name() + " requests are not supported!");
            }
        }
        builder.url(this.url);
        builder.headers(this.getHeaders());
        return builder.build();
    }

    protected Method getMethod() {
        return this.method;
    }

    protected String getUrl() {
        return this.url;
    }

    public void queue() {
        this.queue(DEFAULT_SUCCESS);
    }

    public void queue(Consumer<T> success) {
        this.queue(success, DEFAULT_FAILURE);
    }

    public void queue(Consumer<T> success, Consumer<Throwable> failure) {
        this.client.getRequester().submitAsync(this, success, failure);
    }

    public T complete() throws IOException {
        return this.client.getRequester().submitSync(this);
    }

    public OAuth2ClientImpl getClient() {
        return this.client;
    }

    protected abstract T handle(@WillClose Response var1) throws IOException;
}

