/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.oauth2.requests;

import com.jagrosh.jdautilities.commons.JDAUtilitiesInfo;
import com.jagrosh.jdautilities.oauth2.requests.OAuth2Action;
import java.io.IOException;
import java.util.function.Consumer;
import net.dv8tion.jda.internal.utils.JDALogger;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;

public class OAuth2Requester {
    protected static final Logger LOGGER = JDALogger.getLog(OAuth2Requester.class);
    protected static final String USER_AGENT = "JDA-Utils Oauth2(https://github.com/JDA-Applications/JDA-Utilities | " + JDAUtilitiesInfo.VERSION + ")";
    protected static final RequestBody EMPTY_BODY = RequestBody.create(null, (byte[])new byte[0]);
    private final OkHttpClient httpClient;

    public OAuth2Requester(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    <T> void submitAsync(final OAuth2Action<T> request, final Consumer<T> success, final Consumer<Throwable> failure) {
        this.httpClient.newCall(request.buildRequest()).enqueue(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    Object value = request.handle(response);
                    OAuth2Requester.logSuccessfulRequest(request);
                    try {
                        if (value != null) {
                            success.accept(value);
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.error("OAuth2Action success callback threw an exception!", t);
                    }
                }
                catch (Throwable t) {
                    try {
                        failure.accept(t);
                    }
                    catch (Throwable t1) {
                        LOGGER.error("OAuth2Action success callback threw an exception!", t1);
                    }
                }
                finally {
                    response.close();
                }
            }

            public void onFailure(Call call, IOException e) {
                LOGGER.error("Requester encountered an error when submitting a request!", (Throwable)e);
            }
        });
    }

    <T> T submitSync(OAuth2Action<T> request) throws IOException {
        try (Response response = this.httpClient.newCall(request.buildRequest()).execute();){
            T value = request.handle(response);
            OAuth2Requester.logSuccessfulRequest(request);
            T t = value;
            return t;
        }
    }

    private static void logSuccessfulRequest(OAuth2Action request) {
        LOGGER.debug("Got a response for {} - {}\nHeaders: {}", new Object[]{request.getMethod(), request.getUrl(), request.getHeaders()});
    }
}

