/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.oauth2.requests;

public enum OAuth2URL {
    AUTHORIZE("/oauth2/authorize", "client_id=%d", "redirect_uri=%s", "response_type=code", "scope=%s", "state=%s"),
    TOKEN("/oauth2/token", "client_id=%d", "redirect_uri=%s", "grant_type=authorization_code", "code=%s", "client_secret=%s", "scope=%s"),
    CURRENT_USER("/users/@me", new String[0]),
    CURRENT_USER_GUILDS("/users/@me/guilds", new String[0]);

    public static final String BASE_API_URL;
    private final String route;
    private final String formattableRoute;
    private final boolean hasQueryParams;
    private final String queryParams;

    private OAuth2URL(String route, String ... queryParams) {
        this.route = route;
        boolean bl = this.hasQueryParams = queryParams.length > 0;
        if (this.hasQueryParams) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < queryParams.length; ++i) {
                b.append(i == 0 ? (char)'?' : '&');
                b.append(queryParams[i]);
            }
            this.formattableRoute = route + b.toString();
            this.queryParams = b.toString();
        } else {
            this.formattableRoute = route;
            this.queryParams = "";
        }
    }

    public String getRoute() {
        return this.route;
    }

    public boolean hasQueryParams() {
        return this.hasQueryParams;
    }

    public String compileQueryParams(Object ... values) {
        return String.format(this.queryParams, values).replaceFirst("\\?", "");
    }

    public String getRouteWithBaseUrl() {
        return BASE_API_URL + this.route;
    }

    public String compile(Object ... values) {
        return BASE_API_URL + (this.hasQueryParams ? String.format(this.formattableRoute, values) : this.formattableRoute);
    }

    static {
        BASE_API_URL = String.format("https://discord.com/api/v%d", 6);
    }
}

