/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.oauth2.session;

import com.jagrosh.jdautilities.oauth2.Scope;
import com.jagrosh.jdautilities.oauth2.session.Session;
import com.jagrosh.jdautilities.oauth2.session.SessionController;
import com.jagrosh.jdautilities.oauth2.session.SessionData;
import java.time.OffsetDateTime;
import java.util.HashMap;

public class DefaultSessionController
implements SessionController<DefaultSession> {
    private final HashMap<String, DefaultSession> sessions = new HashMap();

    @Override
    public DefaultSession getSession(String identifier) {
        return this.sessions.get(identifier);
    }

    @Override
    public DefaultSession createSession(SessionData data) {
        DefaultSession created = new DefaultSession(data);
        this.sessions.put(data.getIdentifier(), created);
        return created;
    }

    public class DefaultSession
    implements Session {
        private final String accessToken;
        private final String refreshToken;
        private final String tokenType;
        private final OffsetDateTime expiration;
        private final Scope[] scopes;

        private DefaultSession(String accessToken, String refreshToken, String tokenType, OffsetDateTime expiration, Scope[] scopes) {
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.tokenType = tokenType;
            this.expiration = expiration;
            this.scopes = scopes;
        }

        private DefaultSession(SessionData data) {
            this(data.getAccessToken(), data.getRefreshToken(), data.getTokenType(), data.getExpiration(), data.getScopes());
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public String getRefreshToken() {
            return this.refreshToken;
        }

        @Override
        public Scope[] getScopes() {
            return this.scopes;
        }

        @Override
        public String getTokenType() {
            return this.tokenType;
        }

        @Override
        public OffsetDateTime getExpiration() {
            return this.expiration;
        }
    }
}

