/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.oauth2.session;

import com.jagrosh.jdautilities.oauth2.Scope;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class SessionData {
    private final String identifier;
    private final String accessToken;
    private final String refreshToken;
    private final String tokenType;
    private final OffsetDateTime expiration;
    private final Scope[] scopes;

    public SessionData(String identifier, String accessToken, String refreshToken, String tokenType, OffsetDateTime expiration, Scope[] scopes) {
        this.identifier = identifier;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
        this.expiration = expiration;
        this.scopes = scopes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public Scope[] getScopes() {
        return this.scopes;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SessionData)) {
            return false;
        }
        SessionData data = (SessionData)obj;
        return this.getIdentifier().equals(data.getIdentifier()) && this.getTokenType().equals(data.getTokenType());
    }

    public String toString() {
        return String.format("SessionData(identifier: %s, access-token: %s, refresh-token: %s, type: %s, expires: %s)", this.getIdentifier(), this.getAccessToken(), this.getRefreshToken(), this.getTokenType(), this.getExpiration().format(DateTimeFormatter.RFC_1123_DATE_TIME));
    }
}

