/*
 * Decompiled with CFR 0.152.
 */
package butterknife;

import android.app.Activity;
import android.util.Log;
import android.view.View;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class Views {
    private static final String TAG = "ButterKnife";
    private static boolean debug = false;
    static final Map<Class<?>, Method> INJECTORS = new LinkedHashMap();
    static final Map<Class<?>, Method> RESETTERS = new LinkedHashMap();
    static final Method NO_OP = null;

    private Views() {
    }

    public static void setDebug(boolean debug) {
        Views.debug = debug;
    }

    public static void inject(Activity target) {
        Views.inject(target, target, Finder.ACTIVITY);
    }

    public static void inject(View target) {
        Views.inject(target, target, Finder.VIEW);
    }

    public static void inject(Object target, Activity source) {
        Views.inject(target, source, Finder.ACTIVITY);
    }

    public static void inject(Object target, View source) {
        Views.inject(target, source, Finder.VIEW);
    }

    public static void reset(Object target) {
        Class<?> targetClass = target.getClass();
        try {
            Method reset;
            if (debug) {
                Log.d((String)TAG, (String)("Looking up view injector for " + targetClass.getName()));
            }
            if ((reset = Views.findResettersForClass(targetClass)) != null) {
                reset.invoke(null, target);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnableToResetException("Unable to reset views for " + target, e);
        }
    }

    static void inject(Object target, Object source, Finder finder) {
        Class<?> targetClass = target.getClass();
        try {
            Method inject;
            if (debug) {
                Log.d((String)TAG, (String)("Looking up view injector for " + targetClass.getName()));
            }
            if ((inject = Views.findInjectorForClass(targetClass)) != null) {
                inject.invoke(null, new Object[]{finder, target, source});
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnableToInjectException("Unable to inject views for " + target, e);
        }
    }

    static Method findInjectorForClass(Class<?> cls) throws NoSuchMethodException {
        Method inject = INJECTORS.get(cls);
        if (inject != null) {
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Cached in injector map.");
            }
            return inject;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return NO_OP;
        }
        try {
            Class<?> injector = Class.forName(clsName + "$$ViewInjector");
            inject = injector.getMethod("inject", Finder.class, cls, Object.class);
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Class loaded injection class.");
            }
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                Log.d((String)TAG, (String)("Not found. Trying superclass " + cls.getSuperclass().getName()));
            }
            inject = Views.findInjectorForClass(cls.getSuperclass());
        }
        INJECTORS.put(cls, inject);
        return inject;
    }

    static Method findResettersForClass(Class<?> cls) throws NoSuchMethodException {
        Method inject = RESETTERS.get(cls);
        if (inject != null) {
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Cached in injector map.");
            }
            return inject;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return NO_OP;
        }
        try {
            Class<?> injector = Class.forName(clsName + "$$ViewInjector");
            inject = injector.getMethod("reset", cls);
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Class loaded injection class.");
            }
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                Log.d((String)TAG, (String)("Not found. Trying superclass " + cls.getSuperclass().getName()));
            }
            inject = Views.findResettersForClass(cls.getSuperclass());
        }
        RESETTERS.put(cls, inject);
        return inject;
    }

    public static <T extends View> T findById(View view, int id) {
        return (T)view.findViewById(id);
    }

    public static <T extends View> T findById(Activity activity, int id) {
        return (T)activity.findViewById(id);
    }

    public static class UnableToResetException
    extends RuntimeException {
        UnableToResetException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class UnableToInjectException
    extends RuntimeException {
        UnableToInjectException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static enum Finder {
        VIEW{

            @Override
            public View findById(Object source, int id) {
                return ((View)source).findViewById(id);
            }
        }
        ,
        ACTIVITY{

            @Override
            public View findById(Object source, int id) {
                return ((Activity)source).findViewById(id);
            }
        };


        public abstract View findById(Object var1, int var2);
    }
}

