/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import butterknife.InjectView;
import butterknife.OnClick;
import butterknife.internal.TargetClass;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"butterknife.InjectView", "butterknife.OnClick"})
public class InjectViewProcessor
extends AbstractProcessor {
    public static final String SUFFIX = "$$ViewInjector";
    private Elements elementUtils;
    private Types typeUtils;
    private Filer filer;
    private TypeMirror viewType;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.elementUtils = env.getElementUtils();
        this.typeUtils = env.getTypeUtils();
        this.filer = env.getFiler();
        this.viewType = this.elementUtils.getTypeElement("android.view.View").asType();
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        Map<TypeElement, TargetClass> targetClassMap = this.findAndParseTargets(env);
        for (Map.Entry<TypeElement, TargetClass> entry : targetClassMap.entrySet()) {
            TypeElement typeElement = entry.getKey();
            TargetClass targetClass = entry.getValue();
            try {
                JavaFileObject jfo = this.filer.createSourceFile(targetClass.getFqcn(), typeElement);
                Writer writer = jfo.openWriter();
                writer.write(targetClass.brewJava());
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                this.error(typeElement, "Unable to write injector for type %s: %s", typeElement, e.getMessage());
            }
        }
        return true;
    }

    private Map<TypeElement, TargetClass> findAndParseTargets(RoundEnvironment env) {
        LinkedHashMap<TypeElement, TargetClass> targetClassMap = new LinkedHashMap<TypeElement, TargetClass>();
        LinkedHashSet<TypeMirror> erasedTargetTypes = new LinkedHashSet<TypeMirror>();
        for (Element element : env.getElementsAnnotatedWith(InjectView.class)) {
            TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
            if (!this.typeUtils.isSubtype(element.asType(), this.viewType)) {
                this.error(element, "@InjectView fields must extend from View (%s.%s).", enclosingElement.getQualifiedName(), element);
                continue;
            }
            Set<Modifier> modifiers = element.getModifiers();
            if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC)) {
                this.error(element, "@InjectView fields must not be private or static (%s.%s).", enclosingElement.getQualifiedName(), element);
                continue;
            }
            if (enclosingElement.getKind() != ElementKind.CLASS) {
                this.error(element, "@InjectView field annotations may only be specified in classes (%s).", enclosingElement);
                continue;
            }
            if (enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error(element, "@InjectView fields may not be on private classes (%s).", enclosingElement);
                continue;
            }
            String name = element.getSimpleName().toString();
            int id = element.getAnnotation(InjectView.class).value();
            String type = element.asType().toString();
            TargetClass targetClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
            targetClass.addField(id, name, type);
            TypeMirror erasedTargetType = this.typeUtils.erasure(enclosingElement.asType());
            erasedTargetTypes.add(erasedTargetType);
        }
        for (Element element : env.getElementsAnnotatedWith(OnClick.class)) {
            if (!(element instanceof ExecutableElement)) {
                this.error(element, "@OnClick annotation must be on a method.", new Object[0]);
                continue;
            }
            ExecutableElement executableElement = (ExecutableElement)element;
            TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
            Set<Modifier> modifiers = element.getModifiers();
            if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC)) {
                this.error(element, "@OnClick methods must not be private or static (%s.%s).", enclosingElement.getQualifiedName(), element);
                continue;
            }
            if (enclosingElement.getKind() != ElementKind.CLASS) {
                this.error(element, "@OnClick method annotations may only be specified in classes (%s).", enclosingElement);
                continue;
            }
            if (enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error(element, "@OnClick methods may not be on private classes (%s).", enclosingElement);
                continue;
            }
            if (executableElement.getReturnType().getKind() != TypeKind.VOID) {
                this.error(element, "@OnClick methods must have a 'void' return type (%s.%s).", enclosingElement.getQualifiedName(), element);
                continue;
            }
            String type = null;
            List<? extends VariableElement> parameters = executableElement.getParameters();
            if (!parameters.isEmpty()) {
                if (parameters.size() != 1) {
                    this.error(element, "@OnClick methods may only have one parameter which is View (or subclass) (%s.%s).", enclosingElement.getQualifiedName(), element);
                    continue;
                }
                VariableElement variableElement = parameters.get(0);
                if (!this.typeUtils.isSubtype(variableElement.asType(), this.viewType)) {
                    this.error(element, "@OnClick method parameter must extend from View (%s.%s).", enclosingElement.getQualifiedName(), element);
                    continue;
                }
                type = variableElement.asType().toString();
            }
            String name = executableElement.getSimpleName().toString();
            int[] ids = element.getAnnotation(OnClick.class).value();
            TargetClass targetClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
            boolean bad = false;
            LinkedHashSet<Integer> seenIds = new LinkedHashSet<Integer>();
            for (int id : ids) {
                if (!seenIds.add(id)) {
                    this.error(element, "@OnClick annotation for method %s contains duplicate ID %s.", element, id);
                    bad = true;
                    continue;
                }
                if (targetClass.addMethod(id, name, type)) continue;
                this.error(element, "Multiple @OnClick methods declared for ID %s in %s.", id, enclosingElement.getQualifiedName());
                bad = true;
            }
            if (bad) continue;
            TypeMirror erasedTargetType = this.typeUtils.erasure(enclosingElement.asType());
            erasedTargetTypes.add(erasedTargetType);
        }
        for (Map.Entry entry : targetClassMap.entrySet()) {
            String parentClassFqcn = this.findParentFqcn((TypeElement)entry.getKey(), erasedTargetTypes);
            if (parentClassFqcn == null) continue;
            ((TargetClass)entry.getValue()).setParentInjector(parentClassFqcn + SUFFIX);
        }
        return targetClassMap;
    }

    private TargetClass getOrCreateTargetClass(Map<TypeElement, TargetClass> targetClassMap, TypeElement enclosingElement) {
        TargetClass targetClass = targetClassMap.get(enclosingElement);
        if (targetClass == null) {
            String targetType = enclosingElement.getQualifiedName().toString();
            String classPackage = this.getPackageName(enclosingElement);
            String className = InjectViewProcessor.getClassName(enclosingElement, classPackage) + SUFFIX;
            targetClass = new TargetClass(classPackage, className, targetType);
            targetClassMap.put(enclosingElement, targetClass);
        }
        return targetClass;
    }

    protected static String getClassName(TypeElement type, String packageName) {
        int packageLen = packageName.length() + 1;
        return type.getQualifiedName().toString().substring(packageLen).replace('.', '$');
    }

    private String findParentFqcn(TypeElement typeElement, Set<TypeMirror> parents) {
        TypeMirror type;
        do {
            if ((type = typeElement.getSuperclass()).getKind() == TypeKind.NONE) {
                return null;
            }
            typeElement = (TypeElement)((DeclaredType)type).asElement();
        } while (!this.containsTypeMirror(parents, type));
        String packageName = this.getPackageName(typeElement);
        return packageName + "." + InjectViewProcessor.getClassName(typeElement, packageName);
    }

    private boolean containsTypeMirror(Collection<TypeMirror> mirrors, TypeMirror query) {
        query = this.typeUtils.erasure(query);
        for (TypeMirror mirror : mirrors) {
            if (!this.typeUtils.isSameType(mirror, query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    protected void error(Element element, String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args), element);
    }

    protected String getPackageName(TypeElement type) {
        return this.elementUtils.getPackageOf(type).getQualifiedName().toString();
    }
}

