/*
 * Decompiled with CFR 0.152.
 */
package com.leon.channel.common;

import com.leon.channel.common.ApkSectionInfo;
import com.leon.channel.common.Pair;
import com.leon.channel.common.verify.ApkSignatureSchemeV2Verifier;
import com.leon.channel.common.verify.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.Map;

public class V2SchemeUtil {
    public static Map<Integer, ByteBuffer> getAllIdValue(ByteBuffer apkSchemeBlock) throws ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        ApkSignatureSchemeV2Verifier.checkByteOrderLittleEndian(apkSchemeBlock);
        ByteBuffer pairs = ApkSignatureSchemeV2Verifier.sliceFromTo(apkSchemeBlock, 8, apkSchemeBlock.capacity() - 24);
        LinkedHashMap<Integer, ByteBuffer> idValues = new LinkedHashMap<Integer, ByteBuffer>();
        int entryCount = 0;
        while (pairs.hasRemaining()) {
            ++entryCount;
            if (pairs.remaining() < 8) {
                throw new ApkSignatureSchemeV2Verifier.SignatureNotFoundException("Insufficient data to read size of APK Signing Block entry #" + entryCount);
            }
            long lenLong = pairs.getLong();
            if (lenLong < 4L || lenLong > Integer.MAX_VALUE) {
                throw new ApkSignatureSchemeV2Verifier.SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + lenLong);
            }
            int len = (int)lenLong;
            int nextEntryPos = pairs.position() + len;
            if (len > pairs.remaining()) {
                throw new ApkSignatureSchemeV2Verifier.SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + len + ", available: " + pairs.remaining());
            }
            int id = pairs.getInt();
            idValues.put(id, ApkSignatureSchemeV2Verifier.getByteBuffer(pairs, len - 4));
            if (id == 1896449818) {
                System.out.println("find V2 signature block Id : 1896449818");
            }
            pairs.position(nextEntryPos);
        }
        if (idValues.isEmpty()) {
            throw new ApkSignatureSchemeV2Verifier.SignatureNotFoundException("not have Id-Value Pair in APK Signing Block entry #" + entryCount);
        }
        return idValues;
    }

    public static ByteBuffer getApkSigningBlock(File channelFile) throws ApkSignatureSchemeV2Verifier.SignatureNotFoundException, IOException {
        if (channelFile == null || !channelFile.exists() || !channelFile.isFile()) {
            return null;
        }
        RandomAccessFile apk = new RandomAccessFile(channelFile, "r");
        Pair<ByteBuffer, Long> eocdAndOffsetInFile = ApkSignatureSchemeV2Verifier.getEocd(apk);
        ByteBuffer eocd = eocdAndOffsetInFile.getFirst();
        long eocdOffset = eocdAndOffsetInFile.getSecond();
        if (ZipUtils.isZip64EndOfCentralDirectoryLocatorPresent(apk, eocdOffset)) {
            throw new ApkSignatureSchemeV2Verifier.SignatureNotFoundException("ZIP64 APK not supported");
        }
        long centralDirOffset = ApkSignatureSchemeV2Verifier.getCentralDirOffset(eocd, eocdOffset);
        Pair<ByteBuffer, Long> apkSignatureBlock = ApkSignatureSchemeV2Verifier.findApkSigningBlock(apk, centralDirOffset);
        return apkSignatureBlock.getFirst();
    }

    public static ApkSectionInfo getApkSectionInfo(File baseApk) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        RandomAccessFile apk = new RandomAccessFile(baseApk, "r");
        Pair<ByteBuffer, Long> eocdAndOffsetInFile = ApkSignatureSchemeV2Verifier.getEocd(apk);
        ByteBuffer eocd = eocdAndOffsetInFile.getFirst();
        long eocdOffset = eocdAndOffsetInFile.getSecond();
        if (ZipUtils.isZip64EndOfCentralDirectoryLocatorPresent(apk, eocdOffset)) {
            throw new ApkSignatureSchemeV2Verifier.SignatureNotFoundException("ZIP64 APK not supported");
        }
        long centralDirOffset = ApkSignatureSchemeV2Verifier.getCentralDirOffset(eocd, eocdOffset);
        Pair<ByteBuffer, Long> apkSchemeV2Block = ApkSignatureSchemeV2Verifier.findApkSigningBlock(apk, centralDirOffset);
        Pair<ByteBuffer, Long> centralDir = V2SchemeUtil.findCentralDir(apk, centralDirOffset, (int)(eocdOffset - centralDirOffset));
        Pair<ByteBuffer, Long> contentEntry = V2SchemeUtil.findContentEntry(apk, (int)apkSchemeV2Block.getSecond().longValue());
        ApkSectionInfo apkSectionInfo = new ApkSectionInfo();
        apkSectionInfo.mContentEntry = contentEntry;
        apkSectionInfo.mSchemeV2Block = apkSchemeV2Block;
        apkSectionInfo.mCentralDir = centralDir;
        apkSectionInfo.mEocd = eocdAndOffsetInFile;
        System.out.println("baseApk : " + baseApk.getAbsolutePath() + " , ApkSectionInfo = " + apkSectionInfo);
        return apkSectionInfo;
    }

    public static Pair<ByteBuffer, Long> findCentralDir(RandomAccessFile baseApk, long centralDirOffset, int length) throws IOException {
        ByteBuffer byteBuffer = V2SchemeUtil.getByteBuffer(baseApk, centralDirOffset, length);
        return Pair.create(byteBuffer, centralDirOffset);
    }

    public static Pair<ByteBuffer, Long> findContentEntry(RandomAccessFile baseApk, int length) throws IOException {
        ByteBuffer byteBuffer = V2SchemeUtil.getByteBuffer(baseApk, 0L, length);
        return Pair.create(byteBuffer, 0L);
    }

    private static ByteBuffer getByteBuffer(RandomAccessFile baseApk, long offset, int length) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        baseApk.seek(offset);
        baseApk.readFully(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
        return byteBuffer;
    }

    public static ByteBuffer generateApkSigningBlock(Map<Integer, ByteBuffer> idValueMap) {
        if (idValueMap == null || idValueMap.isEmpty()) {
            throw new RuntimeException("getNewApkV2SchemeBlock , id value pair is empty");
        }
        long length = 24L;
        for (Map.Entry<Integer, ByteBuffer> entry : idValueMap.entrySet()) {
            ByteBuffer byteBuffer = entry.getValue();
            length += (long)(12 + byteBuffer.remaining());
        }
        ByteBuffer newApkV2Scheme = ByteBuffer.allocate((int)(length + 8L));
        newApkV2Scheme.order(ByteOrder.LITTLE_ENDIAN);
        newApkV2Scheme.putLong(length);
        for (Map.Entry<Integer, ByteBuffer> entry : idValueMap.entrySet()) {
            ByteBuffer byteBuffer = entry.getValue();
            newApkV2Scheme.putLong(byteBuffer.remaining() + 4);
            newApkV2Scheme.putInt(entry.getKey());
            newApkV2Scheme.put(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        }
        newApkV2Scheme.putLong(length);
        newApkV2Scheme.putLong(2334950737559900225L);
        newApkV2Scheme.putLong(3617552046287187010L);
        if (newApkV2Scheme.remaining() > 0) {
            throw new RuntimeException("generateNewApkV2SchemeBlock error");
        }
        newApkV2Scheme.flip();
        return newApkV2Scheme;
    }

    public static boolean verifyChannelApk(String apkPath) throws Exception {
        return ApkSignatureSchemeV2Verifier.hasSignature(apkPath);
    }

    public static boolean containV2Signature(File apk, boolean isCommand) {
        try {
            ByteBuffer apkSigningBlock = V2SchemeUtil.getApkSigningBlock(apk);
            Map<Integer, ByteBuffer> idValueMap = V2SchemeUtil.getAllIdValue(apkSigningBlock);
            if (idValueMap.containsKey(1896449818)) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ApkSignatureSchemeV2Verifier.SignatureNotFoundException e) {
            if (!isCommand) {
                e.printStackTrace();
            }
            System.out.println("APK : " + apk.getAbsolutePath() + " not have apk signature block");
        }
        return false;
    }
}

