/*
 * Decompiled with CFR 0.152.
 */
package com.leon.channel.reader;

import com.leon.channel.common.V1SchemeUtil;
import com.leon.channel.common.V2SchemeUtil;
import com.leon.channel.reader.IdValueReader;
import java.io.File;

public class ChannelReader {
    public static String getChannelByV2(File channelFile) {
        System.out.println("try to read channel info from apk : " + channelFile.getAbsolutePath());
        return IdValueReader.getStringValueById(channelFile, -2012129793);
    }

    public static String getChannelByV1(File channelFile) {
        try {
            return V1SchemeUtil.readChannel((File)channelFile);
        }
        catch (Exception e) {
            System.out.println("APK : " + channelFile.getAbsolutePath() + " not have channel info from Zip Comment");
            return null;
        }
    }

    public static boolean verifyChannelByV2(File file, String channel) {
        if (channel != null) {
            return channel.equals(ChannelReader.getChannelByV2(file));
        }
        return false;
    }

    public static boolean verifyChannelByV1(File file, String channel) {
        if (channel != null) {
            return channel.equals(ChannelReader.getChannelByV1(file));
        }
        return false;
    }

    public static boolean containV1Signature(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return false;
        }
        return V1SchemeUtil.containV1Signature((File)file);
    }

    public static boolean containV2Signature(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return false;
        }
        return V2SchemeUtil.containV2Signature((File)file);
    }
}

