/*
 * Decompiled with CFR 0.152.
 */
package com.leon.channel.writer;

import com.leon.channel.common.ApkSectionInfo;
import com.leon.channel.common.V2SchemeUtil;
import com.leon.channel.common.verify.ApkSignatureSchemeV2Verifier;
import com.leon.channel.common.verify.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.Map;

public class IdValueWriter {
    public static void addIdValue(ApkSectionInfo apkSectionInfo, File destApk, int id, ByteBuffer valueBuffer) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        if (id == 1896449818) {
            throw new RuntimeException("addIdValue , id can not is " + String.valueOf(1896449818) + " , v2 signature block use it");
        }
        LinkedHashMap<Integer, ByteBuffer> idValueMap = new LinkedHashMap<Integer, ByteBuffer>();
        idValueMap.put(id, valueBuffer);
        IdValueWriter.addIdValueByteBufferMap(apkSectionInfo, destApk, idValueMap);
    }

    public static void addIdValueByteBufferMap(ApkSectionInfo apkSectionInfo, File destApk, Map<Integer, ByteBuffer> idValueMap) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        if (idValueMap == null || idValueMap.isEmpty()) {
            throw new RuntimeException("addIdValueByteBufferMap , id value pair is empty");
        }
        if (idValueMap.containsKey(1896449818)) {
            idValueMap.remove(1896449818);
        }
        System.out.println("addIdValueByteBufferMap , idValueMap = " + idValueMap);
        Map existentIdValueMap = V2SchemeUtil.getAllIdValue((ByteBuffer)((ByteBuffer)apkSectionInfo.mSchemeV2Block.getFirst()));
        if (!existentIdValueMap.containsKey(1896449818)) {
            throw new ApkSignatureSchemeV2Verifier.SignatureNotFoundException("No APK V2 Signature Scheme block in APK Signing Block");
        }
        System.out.println("addIdValueByteBufferMap , existentIdValueMap = " + existentIdValueMap);
        existentIdValueMap.putAll(idValueMap);
        System.out.println("addIdValueByteBufferMap , finalIdValueMap = " + existentIdValueMap);
        ByteBuffer newApkSigningBlock = V2SchemeUtil.generateApkSigningBlock((Map)existentIdValueMap);
        System.out.println("addIdValueByteBufferMap , oldApkSigningBlock size = " + ((ByteBuffer)apkSectionInfo.mSchemeV2Block.getFirst()).remaining() + " , newApkSigningBlock size = " + newApkSigningBlock.remaining());
        ByteBuffer contentEntry = (ByteBuffer)apkSectionInfo.mContentEntry.getFirst();
        ByteBuffer centralDir = (ByteBuffer)apkSectionInfo.mCentralDir.getFirst();
        ByteBuffer eocd = (ByteBuffer)apkSectionInfo.mEocd.getFirst();
        long centralDirOffset = (Long)apkSectionInfo.mCentralDir.getSecond();
        ZipUtils.setZipEocdCentralDirectoryOffset((ByteBuffer)eocd, (long)(centralDirOffset += (long)(newApkSigningBlock.remaining() - ((ByteBuffer)apkSectionInfo.mSchemeV2Block.getFirst()).remaining())));
        RandomAccessFile fIn = new RandomAccessFile(destApk, "rw");
        long apkLength = contentEntry.remaining() + newApkSigningBlock.remaining() + centralDir.remaining() + eocd.remaining();
        fIn.seek(0L);
        fIn.write(contentEntry.array(), contentEntry.arrayOffset() + contentEntry.position(), contentEntry.remaining());
        fIn.write(newApkSigningBlock.array(), newApkSigningBlock.arrayOffset() + newApkSigningBlock.position(), newApkSigningBlock.remaining());
        fIn.write(centralDir.array(), centralDir.arrayOffset() + centralDir.position(), centralDir.remaining());
        fIn.write(eocd.array(), eocd.arrayOffset() + eocd.position(), eocd.remaining());
        fIn.setLength(apkLength);
        System.out.println("addIdValueByteBufferMap , after add channel , new apk is " + destApk.getAbsolutePath() + " , length = " + apkLength);
    }

    public static void addIdValue(File srcApk, File destApk, int id, byte[] buffer) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        ApkSectionInfo apkSectionInfo = V2SchemeUtil.getApkSectionInfo((File)srcApk);
        ByteBuffer channelByteBuffer = ByteBuffer.wrap(buffer);
        channelByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IdValueWriter.addIdValue(apkSectionInfo, destApk, id, channelByteBuffer);
    }

    public static void addIdValue(File apkFile, int id, byte[] buffer) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        IdValueWriter.addIdValue(apkFile, apkFile, id, buffer);
    }

    public static void addIdValueByteMap(File srcApk, File destApk, Map<Integer, byte[]> idValueByteMap) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        if (idValueByteMap == null || idValueByteMap.isEmpty()) {
            throw new RuntimeException("addIdValueByteMap , idValueByteMap is empty");
        }
        ApkSectionInfo apkSectionInfo = V2SchemeUtil.getApkSectionInfo((File)srcApk);
        LinkedHashMap<Integer, ByteBuffer> idValues = new LinkedHashMap<Integer, ByteBuffer>();
        for (Integer integer : idValueByteMap.keySet()) {
            ByteBuffer channelByteBuffer = ByteBuffer.wrap(idValueByteMap.get(integer));
            channelByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            idValues.put(integer, channelByteBuffer);
        }
        IdValueWriter.addIdValueByteBufferMap(apkSectionInfo, destApk, idValues);
    }

    public static void addIdValueByteMap(File apkFile, Map<Integer, byte[]> idValueByteMap) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        IdValueWriter.addIdValueByteMap(apkFile, apkFile, idValueByteMap);
    }
}

