/*
 * Decompiled with CFR 0.152.
 */
package com.leon.channel.writer;

import com.leon.channel.common.ApkSectionInfo;
import com.leon.channel.common.V1SchemeUtil;
import com.leon.channel.common.V2SchemeUtil;
import com.leon.channel.common.verify.ApkSignatureSchemeV2Verifier;
import com.leon.channel.writer.IdValueWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ChannelWriter {
    public static void addChannel(ApkSectionInfo apkSectionInfo, File destApk, String channel) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        System.out.println("destApk = " + destApk.getAbsolutePath() + " , channel = " + channel);
        if (destApk == null || channel == null || channel.length() <= 0) {
            throw new RuntimeException("addChannel , param invalid, channel = " + channel + " , destApk = " + destApk);
        }
        if (!destApk.getParentFile().exists()) {
            destApk.getParentFile().mkdirs();
        }
        byte[] buffer = channel.getBytes("UTF-8");
        ByteBuffer channelByteBuffer = ByteBuffer.wrap(buffer);
        channelByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IdValueWriter.addIdValue(apkSectionInfo, destApk, -2012129793, channelByteBuffer);
    }

    public static void addChannel(File apkFile, String channel) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        ChannelWriter.addChannel(apkFile, apkFile, channel);
    }

    public static void addChannel(File srcApk, File destApk, String channel) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        ApkSectionInfo apkSectionInfo = V2SchemeUtil.getApkSectionInfo((File)srcApk);
        ChannelWriter.addChannel(apkSectionInfo, destApk, channel);
    }

    public static void addChannelToZipComment(File srcApk, File destApk, String channel) throws Exception {
        V1SchemeUtil.copyFile((File)srcApk, (File)destApk);
        V1SchemeUtil.writeChannel((File)destApk, (String)channel);
    }

    public static void addChannelToZipComment(File apkFile, String channel) throws Exception {
        V1SchemeUtil.writeChannel((File)apkFile, (String)channel);
    }
}

