/*
 * Decompiled with CFR 0.152.
 */
package com.leon.channel.writer;

import com.leon.channel.common.ApkSectionInfo;
import com.leon.channel.common.V1SchemeUtil;
import com.leon.channel.common.verify.ApkSignatureSchemeV2Verifier;
import com.leon.channel.writer.IdValueWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class ChannelWriter {
    public static void addChannelByV2(ApkSectionInfo apkSectionInfo, File destApk, String channel) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        if (destApk == null || channel == null || channel.length() <= 0) {
            throw new RuntimeException("addChannelByV2 , param invalid, channel = " + channel + " , destApk = " + destApk);
        }
        if (apkSectionInfo.lowMemory) {
            if (!destApk.exists() || !destApk.isFile() || destApk.length() <= 0L) {
                throw new RuntimeException("addChannelByV2 , destApk invalid in the lowMemory mode");
            }
        } else if (!destApk.getParentFile().exists()) {
            destApk.getParentFile().mkdirs();
        }
        byte[] buffer = channel.getBytes("UTF-8");
        ByteBuffer channelByteBuffer = ByteBuffer.wrap(buffer);
        channelByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IdValueWriter.addIdValue(apkSectionInfo, destApk, -2012129793, channelByteBuffer);
    }

    public static void addChannelByV2(File apkFile, String channel, boolean lowMemory) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        ChannelWriter.addChannelByV2(apkFile, apkFile, channel, lowMemory);
    }

    public static void addChannelByV2(File srcApk, File destApk, String channel, boolean lowMemory) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        ApkSectionInfo apkSectionInfo = IdValueWriter.getApkSectionInfo(srcApk, lowMemory);
        ChannelWriter.addChannelByV2(apkSectionInfo, destApk, channel);
    }

    public static void addChannelByV1(File srcApk, File destApk, String channel) throws Exception {
        V1SchemeUtil.copyFile((File)srcApk, (File)destApk);
        ChannelWriter.addChannelByV1(destApk, channel);
    }

    public static void addChannelByV1(File apkFile, String channel) throws Exception {
        V1SchemeUtil.writeChannel((File)apkFile, (String)channel);
    }

    public static void removeChannelByV2(File destApk, boolean lowMemory) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        if (destApk == null || !destApk.isFile() || !destApk.exists()) {
            return;
        }
        ApkSectionInfo apkSectionInfo = IdValueWriter.getApkSectionInfo(destApk, lowMemory);
        ArrayList<Integer> idList = new ArrayList<Integer>();
        idList.add(-2012129793);
        IdValueWriter.removeIdValue(apkSectionInfo, destApk, idList);
        apkSectionInfo.checkParamters();
    }

    public static void removeChannelByV1(File destApk) throws Exception {
        V1SchemeUtil.removeChannelByV1((File)destApk);
    }
}

