/*
 * Decompiled with CFR 0.152.
 */
package com.leroymerlin.pandroid.security;

import com.leroymerlin.pandroid.security.Base64Support;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEncryption {
    private static final String AES_ALGO = "AES";
    private static final String AES_FORMAT = "AES/CBC/PKCS5PADDING";
    private static final Random random = new Random();

    public static String symetricEncrypt(String seed, String data) throws UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException {
        byte[] encryptionKey = AESEncryption.get128BitsKey(seed);
        byte[] clearText = data.getBytes("UTF-8");
        SecretKeySpec key = new SecretKeySpec(encryptionKey, AES_ALGO);
        Cipher cipher = Cipher.getInstance(AES_FORMAT);
        byte[] vectorBytes = AESEncryption.get16BitsKey();
        IvParameterSpec ivParameterSpec = new IvParameterSpec(vectorBytes);
        cipher.init(1, (Key)key, ivParameterSpec);
        byte[] encodedValue = cipher.doFinal(clearText);
        byte[] combined = new byte[encodedValue.length + vectorBytes.length];
        System.arraycopy(encodedValue, 0, combined, 0, encodedValue.length);
        System.arraycopy(vectorBytes, 0, combined, encodedValue.length, vectorBytes.length);
        return new String(Base64Support.encode(combined, 2), "UTF-8");
    }

    public static String symetricDecrypt(String seed, String encryptedData) throws NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, UnsupportedEncodingException {
        byte[] encryptionKey = AESEncryption.get128BitsKey(seed);
        SecretKeySpec key = new SecretKeySpec(encryptionKey, AES_ALGO);
        byte[] encrypedPwdBytes = Base64Support.decode(encryptedData, 2);
        int vectorSize = 16;
        int spiteByteIndex = encrypedPwdBytes.length - vectorSize;
        IvParameterSpec ivParameterSpec = new IvParameterSpec(encrypedPwdBytes, spiteByteIndex, vectorSize);
        Cipher cipher = Cipher.getInstance(AES_FORMAT);
        cipher.init(2, (Key)key, ivParameterSpec);
        byte[] decrypedValueBytes = cipher.doFinal(Arrays.copyOf(encrypedPwdBytes, spiteByteIndex));
        return new String(decrypedValueBytes, "UTF-8");
    }

    private static byte[] get128BitsKey(String seed) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(seed.getBytes());
        return Arrays.copyOf(md.digest(), 16);
    }

    private static byte[] get16BitsKey() throws NoSuchAlgorithmException {
        byte[] b = new byte[16];
        random.nextBytes(b);
        return b;
    }
}

