/*
 * Decompiled with CFR 0.152.
 */
package com.leroymerlin.pandroid.future;

import com.leroymerlin.pandroid.future.ActionDelegate;
import com.leroymerlin.pandroid.future.ProgressActionDelegate;

public class ActionDelegateWrapper<T>
implements ActionDelegate<T> {
    protected int rest;
    protected final int count;
    protected final ActionDelegate<T> delegate;
    protected T lastResult;
    protected Exception lastError;

    public ActionDelegateWrapper(ActionDelegate<T> delegate, int count) {
        this.count = count;
        this.delegate = delegate;
    }

    @Override
    public void onError(Exception e) {
        this.lastError = e;
        this.next();
    }

    @Override
    public void onSuccess(T result) {
        this.lastResult = result;
        this.next();
    }

    protected void next() {
        ++this.rest;
        if (this.delegate instanceof ProgressActionDelegate) {
            ((ProgressActionDelegate)this.delegate).onProgress((int)((float)this.rest / (float)this.count * 100.0f));
        }
        if (this.rest == this.count) {
            this.publishResult();
        }
    }

    protected void publishResult() {
        if (this.lastError != null) {
            this.delegate.onError(this.lastError);
        } else {
            this.delegate.onSuccess(this.lastResult);
        }
    }
}

