/*
 * Decompiled with CFR 0.152.
 */
package com.leroymerlin.pandroid.future;

import com.leroymerlin.pandroid.future.ActionDelegate;
import com.leroymerlin.pandroid.future.CancellableActionDelegate;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.disposables.Disposable;

public class RxActionDelegate<T>
extends CancellableActionDelegate<T>
implements Disposable {
    private ActionDelegate<T> wrapDelegate;

    private RxActionDelegate(ActionDelegate<T> delegate) {
        this.wrapDelegate = delegate;
    }

    public static Completable completable(final OnSubscribeAction<Void> subscribe) {
        return Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(){

            public void subscribe(final CompletableEmitter emitter) throws Exception {
                RxActionDelegate delegate = new RxActionDelegate(new ActionDelegate<Void>(){

                    @Override
                    public void onSuccess(Void result) {
                        emitter.onComplete();
                    }

                    @Override
                    public void onError(Exception e) {
                        emitter.onError((Throwable)e);
                    }
                });
                emitter.setDisposable(delegate);
                subscribe.subscribe(delegate);
            }
        });
    }

    public static <T> Single<T> single(final OnSubscribeAction<T> subscribe) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(){

            public void subscribe(final SingleEmitter<T> emitter) throws Exception {
                RxActionDelegate delegate = new RxActionDelegate(new ActionDelegate<T>(){

                    @Override
                    public void onSuccess(T result) {
                        emitter.onSuccess(result);
                    }

                    @Override
                    public void onError(Exception e) {
                        emitter.onError((Throwable)e);
                    }
                });
                emitter.setDisposable(delegate);
                subscribe.subscribe(delegate);
            }
        });
    }

    public static <T> Single<Result<T>> singleWrapped(final OnSubscribeAction<T> subscribe) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<Result<T>>(){

            public void subscribe(final SingleEmitter<Result<T>> emitter) throws Exception {
                RxActionDelegate delegate = new RxActionDelegate(new ActionDelegate<T>(){

                    @Override
                    public void onSuccess(T result) {
                        emitter.onSuccess(new Result(result));
                    }

                    @Override
                    public void onError(Exception e) {
                        emitter.onSuccess(new Result(e));
                    }
                });
                emitter.setDisposable(delegate);
                subscribe.subscribe(delegate);
            }
        });
    }

    public static <T> Observable<T> observable(final OnSubscribeAction<T> subscribe) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(final ObservableEmitter<T> emitter) throws Exception {
                RxActionDelegate delegate = new RxActionDelegate(new ActionDelegate<T>(){

                    @Override
                    public void onSuccess(T result) {
                        emitter.onNext(result);
                    }

                    @Override
                    public void onError(Exception e) {
                        emitter.onError((Throwable)e);
                    }
                });
                emitter.setDisposable(delegate);
                subscribe.subscribe(delegate);
            }
        });
    }

    public static <T> Observable<Result<T>> observableWrapped(final OnSubscribeAction<T> subscribe) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Result<T>>(){

            public void subscribe(final ObservableEmitter<Result<T>> emitter) throws Exception {
                RxActionDelegate delegate = new RxActionDelegate(new ActionDelegate<T>(){

                    @Override
                    public void onSuccess(T result) {
                        emitter.onNext(new Result(result));
                    }

                    @Override
                    public void onError(Exception e) {
                        emitter.onNext(new Result(e));
                    }
                });
                emitter.setDisposable(delegate);
                subscribe.subscribe(delegate);
            }
        });
    }

    public static <T> Result<T> wrap(T value) {
        return new Result<T>(value);
    }

    @Override
    protected void success(T result) {
        if (this.wrapDelegate != null) {
            this.wrapDelegate.onSuccess(result);
        }
    }

    @Override
    protected void error(Exception e) {
        if (this.wrapDelegate != null) {
            this.wrapDelegate.onError(e);
        }
    }

    public void dispose() {
        this.cancel();
    }

    public boolean isDisposed() {
        return this.isCancelled();
    }

    public static interface OnSubscribeAction<T> {
        public void subscribe(ActionDelegate<T> var1);
    }

    public static class Result<T> {
        public T result;
        public Exception error;

        Result(T result) {
            this.result = result;
        }

        Result(Exception error) {
            this.error = error;
        }

        public boolean hasResult() {
            return this.result != null;
        }
    }
}

