/*
 * Decompiled with CFR 0.152.
 */
package com.leroymerlin.pandroid.log;

import com.leroymerlin.pandroid.log.LogWrapper;

public abstract class SimpleLogger
implements LogWrapper {
    protected boolean debuggable = false;
    protected int logLevel = 2;

    public boolean shouldLog(int i) {
        return this.debuggable && i >= this.logLevel;
    }

    @Override
    public void setLogLevel(int level) {
        this.logLevel = level;
    }

    @Override
    public void addLogger(LogWrapper logWrapper) {
        throw new IllegalStateException("SimpleLogger can't wrap an other logger");
    }

    @Override
    public void removeLogger(LogWrapper logWrapper) {
        throw new IllegalStateException("SimpleLogger can't wrap an other logger");
    }

    @Override
    public void setDebug(boolean isDebug) {
        this.debuggable = isDebug;
    }

    @Override
    public void v(String tag, String msg) {
        if (this.shouldLog(2)) {
            this.verbose(tag, msg, null);
        }
    }

    @Override
    public void v(String tag, String msg, Throwable tr) {
        if (this.shouldLog(2)) {
            this.verbose(tag, msg, tr);
        }
    }

    @Override
    public void d(String tag, String msg) {
        if (this.shouldLog(3)) {
            this.debug(tag, msg, null);
        }
    }

    @Override
    public void d(String tag, String msg, Throwable tr) {
        if (this.shouldLog(3)) {
            this.debug(tag, msg, tr);
        }
    }

    @Override
    public void i(String tag, String msg) {
        if (this.shouldLog(4)) {
            this.info(tag, msg, null);
        }
    }

    @Override
    public void i(String tag, String msg, Throwable tr) {
        if (this.shouldLog(4)) {
            this.info(tag, msg, tr);
        }
    }

    @Override
    public void w(String tag, String msg) {
        if (this.shouldLog(5)) {
            this.warn(tag, msg, null);
        }
    }

    @Override
    public void w(String tag, String msg, Throwable tr) {
        if (this.shouldLog(5)) {
            this.warn(tag, msg, tr);
        }
    }

    @Override
    public void w(String tag, Throwable tr) {
        if (this.shouldLog(5)) {
            this.warn(tag, this.getMessage(tr), tr);
        }
    }

    @Override
    public void e(String tag, String msg) {
        if (this.shouldLog(6)) {
            this.error(tag, msg, null);
        }
    }

    @Override
    public void e(String tag, Throwable tr) {
        if (this.shouldLog(6)) {
            this.error(tag, this.getMessage(tr), tr);
        }
    }

    @Override
    public void e(String tag, String msg, Throwable tr) {
        if (this.shouldLog(6)) {
            this.error(tag, msg, tr);
        }
    }

    @Override
    public void wtf(String tag, String msg) {
        if (this.shouldLog(7)) {
            this.logAssert(tag, msg, null);
        }
    }

    @Override
    public void wtf(String tag, Throwable tr) {
        if (this.shouldLog(7)) {
            this.logAssert(tag, this.getMessage(tr), tr);
        }
    }

    @Override
    public void wtf(String tag, String msg, Throwable tr) {
        if (this.shouldLog(7)) {
            this.logAssert(tag, msg, tr);
        }
    }

    private String getMessage(Throwable tr) {
        if (tr == null || tr.getMessage() == null) {
            return "";
        }
        return tr.getMessage();
    }

    @Override
    public void addKey(String key, String value) {
    }

    public abstract void debug(String var1, String var2, Throwable var3);

    public abstract void verbose(String var1, String var2, Throwable var3);

    public abstract void info(String var1, String var2, Throwable var3);

    public abstract void warn(String var1, String var2, Throwable var3);

    public abstract void error(String var1, String var2, Throwable var3);

    public abstract void logAssert(String var1, String var2, Throwable var3);
}

