/*
 * Decompiled with CFR 0.152.
 */
package com.leroymerlin.pandroid.future;

import com.leroymerlin.pandroid.future.Cancellable;
import com.leroymerlin.pandroid.future.ProgressActionDelegate;
import com.leroymerlin.pandroid.log.LogWrapper;
import com.leroymerlin.pandroid.log.PandroidLogger;
import java.util.ArrayList;
import java.util.List;

public abstract class CancellableActionDelegate<T>
implements ProgressActionDelegate<T>,
Cancellable {
    private String TAG = "CancellableActionDelegate";
    LogWrapper logWrapper = PandroidLogger.getInstance();
    protected boolean cancel;
    private List<CancelListener> listeners = new ArrayList<CancelListener>();

    protected abstract void success(T var1);

    protected abstract void error(Exception var1);

    @Override
    public void cancel() {
        this.cancel = true;
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).onCancel();
            this.listeners.remove(i);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void onSuccess(T result) {
        if (!this.isCancelled()) {
            this.success(result);
        } else {
            this.logWrapper.d(this.TAG, "Action cancelled: Result ignored");
        }
    }

    @Override
    public void onProgress(int percent) {
    }

    @Override
    public void onError(Exception e) {
        if (!this.isCancelled()) {
            this.error(e);
        } else {
            this.logWrapper.d(this.TAG, "Action cancelled: Error ignored", e);
        }
    }

    public void addCancelListener(CancelListener listener) {
        this.listeners.add(listener);
    }

    public void removeCancelListener(CancelListener listener) {
        this.listeners.remove(listener);
    }

    public CancellableActionDelegate<T> register(Cancellable.CancellableRegister register) {
        register.registerDelegate(this);
        return this;
    }

    public static interface CancelListener {
        public void onCancel();
    }
}

