/*
 * Decompiled with CFR 0.152.
 */
package com.leroymerlin.pandroid.future;

import com.leroymerlin.pandroid.future.ActionDelegate;
import com.leroymerlin.pandroid.future.CancellableActionDelegate;
import java.util.ArrayList;
import java.util.List;

public class ChainedActionDelegate<R>
extends CancellableActionDelegate<R> {
    private final StartDelegate<R> startDelegate;
    List<Object> delegates = new ArrayList<Object>();

    private ChainedActionDelegate(StartDelegate<R> delegate) {
        this.startDelegate = delegate;
    }

    @Override
    protected void success(R result) {
        while (!this.delegates.isEmpty()) {
            Object delegate = this.delegates.remove(0);
            if (delegate instanceof SuccessDelegate) {
                ((SuccessDelegate)delegate).success(result, this);
                break;
            }
            if (!(delegate instanceof ActionDelegate)) continue;
            ((ActionDelegate)delegate).onSuccess(result);
            break;
        }
    }

    @Override
    protected void error(Exception e) {
        while (!this.delegates.isEmpty()) {
            Object delegate = this.delegates.remove(0);
            if (delegate instanceof ErrorDelegate) {
                ((ErrorDelegate)delegate).error(e, this);
                break;
            }
            if (!(delegate instanceof ActionDelegate)) continue;
            ((ActionDelegate)delegate).onError(e);
            break;
        }
    }

    public <T> ChainedActionDelegate<T> then(SuccessDelegate<R, T> successDelegate) {
        this.delegates.add(successDelegate);
        return this;
    }

    public ActionStarter finish(ActionDelegate<R> actionDelegate) {
        if (this.delegates instanceof CancellableActionDelegate) {
            ((CancellableActionDelegate)((Object)this.delegates)).addCancelListener(new CancellableActionDelegate.CancelListener(){

                @Override
                public void onCancel() {
                    ChainedActionDelegate.this.cancel();
                }
            });
        }
        this.delegates.add(actionDelegate);
        return new ActionStarter(){

            @Override
            public void start() {
                ChainedActionDelegate.this.start();
            }
        };
    }

    public void start() {
        this.startDelegate.start(this);
    }

    public ChainedActionDelegate<R> error(ErrorDelegate errorDelegate) {
        this.delegates.add(errorDelegate);
        return this;
    }

    public static <T> ChainedActionDelegate<T> create(StartDelegate<T> delegate) {
        return new ChainedActionDelegate<T>(delegate);
    }

    public static interface ErrorDelegate<T> {
        public void error(Exception var1, ActionDelegate<T> var2);
    }

    public static interface SuccessDelegate<R, T> {
        public void success(R var1, ActionDelegate<T> var2);
    }

    public static interface StartDelegate<T> {
        public void start(ActionDelegate<T> var1);
    }

    public static interface ActionStarter {
        public void start();
    }
}

