/*
 * Decompiled with CFR 0.152.
 */
package com.leroymerlin.pandroid.future;

import com.leroymerlin.pandroid.future.ActionDelegate;
import com.leroymerlin.pandroid.log.LogWrapper;
import com.leroymerlin.pandroid.log.PandroidLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class ConcatActionDelegate<P, W, R>
implements ActionDelegate<W> {
    LogWrapper logWrapper = PandroidLogger.getInstance();
    private static final String TAG = ConcatActionDelegate.class.getSimpleName();
    protected final Stack<P> stack;
    protected List<R> result = new ArrayList<R>();
    private final ActionDelegate<List<R>> delegate;

    public ConcatActionDelegate(Stack<P> stack, ActionDelegate<List<R>> delegate) {
        this.delegate = delegate;
        this.stack = stack;
    }

    @Override
    public void onSuccess(W result) {
        if (this.continueStack(result)) {
            this.next();
        }
    }

    protected abstract boolean continueStack(W var1);

    @Override
    public void onError(Exception e) {
        this.logWrapper.e(TAG, e.getMessage(), e);
        this.next();
    }

    protected void next() {
        if (this.stack.isEmpty()) {
            this.delegate.onSuccess(this.result);
        } else {
            this.onNext(this.stack.pop());
        }
    }

    public void perform() {
        this.next();
    }

    public abstract void onNext(P var1);
}

