/*
 * Decompiled with CFR 0.152.
 */
package com.leroymerlin.pandroid.future;

import com.leroymerlin.pandroid.future.ActionDelegate;
import com.leroymerlin.pandroid.log.LogWrapper;
import com.leroymerlin.pandroid.log.PandroidLogger;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;

public class CyclicBarrierActionDelegate<T>
implements ActionDelegate<T> {
    private static final String TAG = CyclicBarrierActionDelegate.class.getSimpleName();
    LogWrapper logWrapper = PandroidLogger.getInstance();
    private CyclicBarrier barrier = new CyclicBarrier(2);
    private T result;
    private Exception exception;

    public T waitDone() throws Exception {
        return this.waitDone(60);
    }

    public T waitDone(int timeOut) throws Exception {
        this.barrier.await(timeOut, TimeUnit.SECONDS);
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    @Override
    public void onSuccess(T result) {
        this.result = result;
        try {
            this.barrier.await();
        }
        catch (Exception e) {
            this.logWrapper.e(TAG, e.getMessage(), e);
        }
    }

    @Override
    public void onError(Exception e) {
        this.exception = e;
        try {
            this.barrier.await();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

