/*
 * Decompiled with CFR 0.152.
 */
package com.mauriciotogneri.javautils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mauriciotogneri.javautils.FormattedDateTime;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.joda.time.DateTime;

public class Json {
    private static final Gson gson = new Gson();

    public static Gson create(Boolean prettyPrint) {
        return Json.builder(prettyPrint).create();
    }

    public static Gson create() {
        return Json.create(false);
    }

    public static <T> T object(String string, Class<T> type) {
        return (T)gson.fromJson(string, type);
    }

    public static <T> T object(JsonElement json, Class<T> type) {
        return (T)gson.fromJson(json, type);
    }

    public static <T> T object(Map<?, ?> map, Class<T> type) {
        return Json.object(gson.toJson(map), type);
    }

    public static <T> T object(String json, Type type) {
        return (T)gson.fromJson(json, type);
    }

    public static String json(Object object) {
        return gson.toJson(object);
    }

    public static JsonObject jsonObject(Object object) {
        return Json.jsonObject(Json.json(object));
    }

    public static JsonObject jsonObject(String string) {
        JsonParser parser = new JsonParser();
        return parser.parse(string).getAsJsonObject();
    }

    public static <A, B extends JsonToObject<A>> List<A> list(B[] list) {
        ArrayList<A> result = new ArrayList<A>();
        if (list != null) {
            for (B json : list) {
                result.add(json.object());
            }
        }
        return result;
    }

    public static <A, B extends JsonToObject<A>> A[] array(B[] list, Class<A> clazz) {
        List newList = Json.list(list);
        Object[] result = (Object[])Array.newInstance(clazz, list.length);
        newList.toArray(result);
        return result;
    }

    public static GsonBuilder builder(Boolean prettyPrint) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeAdapter());
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumAdapterFactory());
        if (prettyPrint.booleanValue()) {
            builder.setPrettyPrinting();
            builder.disableHtmlEscaping();
        }
        return builder;
    }

    public static class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Class<T> classOfT;
        private final Map<String, T> nameToConstant = new HashMap<String, T>();
        private final Map<T, String> constantToName = new HashMap<T, String>();

        public EnumTypeAdapter(Class<T> classOfT) {
            try {
                this.classOfT = classOfT;
                for (Enum constant : (Enum[])classOfT.getEnumConstants()) {
                    String name = constant.name();
                    SerializedName annotation = classOfT.getField(name).getAnnotation(SerializedName.class);
                    if (annotation != null) {
                        name = annotation.value();
                    }
                    this.nameToConstant.put(name, constant);
                    this.constantToName.put(constant, name);
                }
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError();
            }
        }

        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String value = in.nextString();
            Enum result = (Enum)this.nameToConstant.get(value);
            if (result == null) {
                throw new RuntimeException(String.format("Invalid enum value '%s' for type '%s'", value, this.classOfT.getName()));
            }
            return (T)result;
        }

        public void write(JsonWriter out, T value) throws IOException {
            out.value(value == null ? null : this.constantToName.get(value));
        }
    }

    private static class EnumAdapterFactory
    implements TypeAdapterFactory {
        private EnumAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class rawType = typeToken.getRawType();
            if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                return null;
            }
            if (!rawType.isEnum()) {
                rawType = rawType.getSuperclass();
            }
            return new EnumTypeAdapter(rawType);
        }
    }

    private static class DateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final FormattedDateTime formatter = new FormattedDateTime();

        private DateTypeAdapter() {
        }

        public JsonElement serialize(Date date, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(this.formatter.date(new DateTime((Object)date), Locale.getDefault()));
        }

        public Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            try {
                return this.formatter.date(jsonElement.getAsString()).toDate();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error parsing date: %s", jsonElement.getAsString()));
            }
        }
    }

    private static class DateTimeTypeAdapter
    implements JsonSerializer<DateTime>,
    JsonDeserializer<DateTime> {
        private final FormattedDateTime formatter = new FormattedDateTime();

        private DateTimeTypeAdapter() {
        }

        public JsonElement serialize(DateTime dateTime, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(this.formatter.date(dateTime, Locale.getDefault()));
        }

        public DateTime deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            try {
                return this.formatter.date(jsonElement.getAsString());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error parsing date: %s", jsonElement.getAsString()));
            }
        }
    }

    public static interface JsonToObject<T> {
        public T object();
    }
}

