/*
 * Decompiled with CFR 0.152.
 */
package com.mauriciotogneri.javautils;

import com.mauriciotogneri.javautils.Randomized;

public class EnumValue {
    public static <T extends Enum<T>> T from(Class<T> clazz, String text, T defaultValue, Mode mode) {
        String input = mode.format(text);
        for (Enum value : (Enum[])clazz.getEnumConstants()) {
            if (!value.toString().equals(input)) continue;
            return (T)value;
        }
        return defaultValue;
    }

    public static <T extends Enum<T>> T from(Class<T> clazz, String text, T defaultValue) {
        return EnumValue.from(clazz, text, defaultValue, Mode.NORMAL);
    }

    public static <T extends Enum<T>> T from(Class<T> clazz, String text, Mode mode) {
        return EnumValue.from(clazz, text, null, mode);
    }

    public static <T extends Enum<T>> T from(Class<T> clazz, String text) {
        return EnumValue.from(clazz, text, null, Mode.NORMAL);
    }

    public static <T extends Enum> T random(Class<T> clazz) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        return (T)values[Randomized.of(0, values.length - 1)];
    }

    public static enum Mode {
        NORMAL,
        UPPERCASE,
        LOWERCASE;


        public String format(String text) {
            if (text != null) {
                if (this == UPPERCASE) {
                    return text.toUpperCase();
                }
                if (this == LOWERCASE) {
                    return text.toLowerCase();
                }
            }
            return text;
        }
    }
}

