/*
 * Decompiled with CFR 0.152.
 */
package com.mauriciotogneri.javautils;

import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class FormattedDateTime {
    private final DateTimeFormatter formatter;

    public FormattedDateTime(DateTimeFormatter formatter, DateTimeFormatter ... formatters) {
        this.formatter = new DateTimeFormatterBuilder().append(formatter.getPrinter(), this.parsers(formatter, formatters)).toFormatter();
    }

    public FormattedDateTime(String pattern, String ... patterns) {
        this.formatter = new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern((String)pattern).getPrinter(), this.parsers(pattern, patterns)).toFormatter();
    }

    public FormattedDateTime() {
        this("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", new String[0]);
    }

    private DateTimeParser[] parsers(DateTimeFormatter formatter, DateTimeFormatter ... formatters) {
        DateTimeParser[] parsers = new DateTimeParser[formatters.length + 1];
        parsers[0] = formatter.getParser();
        for (int i = 0; i < formatters.length; ++i) {
            parsers[i + 1] = formatters[i].getParser();
        }
        return parsers;
    }

    private DateTimeParser[] parsers(String pattern, String ... patterns) {
        DateTimeParser[] parsers = new DateTimeParser[patterns.length + 1];
        parsers[0] = DateTimeFormat.forPattern((String)pattern).getParser();
        for (int i = 0; i < patterns.length; ++i) {
            parsers[i + 1] = DateTimeFormat.forPattern((String)patterns[i]).getParser();
        }
        return parsers;
    }

    public String date(DateTime dateTime, DateTimeZone timeZone, Locale locale, String defaultValue) {
        if (dateTime != null && timeZone != null && locale != null) {
            try {
                return this.formatter.withZone(timeZone).withLocale(locale).print((ReadableInstant)dateTime);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String date(DateTime dateTime, Locale locale, String defaultValue) {
        return this.date(dateTime, DateTimeZone.getDefault(), locale, defaultValue);
    }

    public String date(DateTime dateTime, DateTimeZone timeZone, Locale locale) {
        return this.date(dateTime, timeZone, locale, null);
    }

    public String date(DateTime dateTime, Locale locale) {
        return this.date(dateTime, DateTimeZone.getDefault(), locale, null);
    }

    public DateTime date(String timestamp, DateTimeZone timeZone, DateTime defaultValue) {
        if (timestamp != null && timeZone != null) {
            try {
                return this.formatter.withZone(timeZone).parseDateTime(timestamp);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public DateTime date(String timestamp, DateTime defaultValue) {
        return this.date(timestamp, DateTimeZone.getDefault(), defaultValue);
    }

    public DateTime date(String timestamp, DateTimeZone timeZone) {
        return this.date(timestamp, timeZone, null);
    }

    public DateTime date(String timestamp) {
        return this.date(timestamp, DateTimeZone.getDefault(), null);
    }
}

