/*
 * Decompiled with CFR 0.152.
 */
package com.mauriciotogneri.javautils;

import java.text.NumberFormat;
import java.util.Locale;

public class FormattedNumber {
    private final Locale locale;
    private final Integer minDecimals;
    private final Integer maxDecimals;
    private final Boolean withSign;

    private FormattedNumber(Locale locale, Integer minDecimals, Integer maxDecimals, Boolean withSign) {
        this.locale = locale;
        this.minDecimals = minDecimals;
        this.maxDecimals = maxDecimals;
        this.withSign = withSign;
    }

    public String format(double value) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(this.locale);
        if (this.minDecimals != null) {
            numberFormat.setMinimumFractionDigits(this.minDecimals);
        }
        if (this.maxDecimals != null) {
            numberFormat.setMaximumFractionDigits(this.maxDecimals);
        }
        if (this.withSign != null && this.withSign.booleanValue()) {
            return String.format("+%s", numberFormat.format(value));
        }
        return numberFormat.format(value);
    }

    public static class Builder {
        private final Locale locale;
        private Integer minDecimals;
        private Integer maxDecimals;
        private Boolean withSign;

        public Builder(Locale locale) {
            this.locale = locale;
        }

        public void minDecimals(Integer minDecimals) {
            this.minDecimals = minDecimals;
        }

        public void maxDecimals(Integer maxDecimals) {
            this.maxDecimals = maxDecimals;
        }

        public void withSign(Boolean withSign) {
            this.withSign = withSign;
        }

        public FormattedNumber build() {
            return new FormattedNumber(this.locale, this.minDecimals, this.maxDecimals, this.withSign);
        }
    }
}

