/*
 * Decompiled with CFR 0.152.
 */
package com.mauriciotogneri.javautils;

import com.mauriciotogneri.javautils.Randomized;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Lists {
    private Lists() {
    }

    public static <T> T random(List<T> list) {
        return list.get(Randomized.nextInt(list.size()));
    }

    public static <T> T[] asArray(Collection<T> list, Class<T> clazz) {
        Object[] result = (Object[])Array.newInstance(clazz, list.size());
        list.toArray(result);
        return result;
    }

    public static <T> T[] arrayAppend(T[] array, T value, Class<T> clazz) {
        Object[] result = (Object[])Array.newInstance(clazz, array.length + 1);
        System.arraycopy(array, 0, result, 0, array.length);
        result[result.length - 1] = value;
        return result;
    }

    public static <T> List<T> split(String list, String separator, Factory<T> factory) {
        ArrayList<T> result = new ArrayList<T>();
        if (list != null) {
            String[] parts;
            for (String part : parts = list.split(separator)) {
                T element;
                try {
                    element = factory.create(part);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                result.add(element);
            }
        }
        return result;
    }

    public static interface Factory<T> {
        public T create(String var1) throws Exception;
    }
}

