/*
 * Decompiled with CFR 0.152.
 */
package com.mauriciotogneri.javautils;

import java.util.Random;

public class Randomized {
    private static final Random random = new Random();

    private Randomized() {
    }

    public static boolean chance(int valid, int outOf) {
        return Randomized.nextInt(outOf) < valid;
    }

    public static boolean chance(int outOf) {
        return Randomized.nextInt(outOf) == 0;
    }

    public static int of(int min, int max) {
        return Randomized.nextInt(max - min + 1) + min;
    }

    public static int nextInt() {
        return random.nextInt();
    }

    public static int nextInt(int max) {
        return random.nextInt(max);
    }

    public static long nextLong() {
        return random.nextLong();
    }

    public static double nextDouble() {
        return random.nextDouble();
    }

    public static double nextDouble(int places) {
        return Randomized.nextDouble() * Math.pow(10.0, places);
    }

    public static double nextDouble(double max) {
        return Randomized.nextDouble() * max;
    }

    public static double nextSignedDouble() {
        return Randomized.nextDouble() * (double)Randomized.sign();
    }

    public static double nextSignedDouble(double max) {
        return Randomized.nextDouble(max) * (double)Randomized.sign();
    }

    public static int sign() {
        return Randomized.nextBoolean() ? 1 : -1;
    }

    public static boolean nextBoolean() {
        return random.nextBoolean();
    }
}

