/*
 * Decompiled with CFR 0.152.
 */
package com.mauriciotogneri.javautils;

import com.mauriciotogneri.javautils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class Record {
    private final File file;

    public Record(File file) {
        this.file = file;
    }

    public Record(String path) {
        this(new File(path));
    }

    public Record(File parent, String path) {
        this(new File(parent, path));
    }

    public Record(Record parent, String path) {
        this(new File(parent.file, path));
    }

    public File file() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String name() {
        return this.file.getName();
    }

    public String path() {
        return this.file.getAbsolutePath();
    }

    public long size() {
        return this.file.length();
    }

    public String extension() {
        String name = this.name();
        int index = name.lastIndexOf(".");
        if (index > -1) {
            String extension = name.substring(index + 1);
            return extension.trim();
        }
        return "";
    }

    public Record parent() {
        return new Record(this.file.getParentFile());
    }

    public boolean rename(String name) {
        File newFile = new File(this.file.getParentFile(), name);
        return !newFile.exists() && this.file.renameTo(newFile);
    }

    public List<Record> children() {
        File[] children;
        ArrayList<Record> result = new ArrayList<Record>();
        if (this.isDirectory() && (children = this.file.listFiles()) != null) {
            for (File child : children) {
                if (child == null) continue;
                result.add(new Record(child));
            }
        }
        return result;
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean create() throws IOException {
        if (this.isFile()) {
            return this.createFile();
        }
        return this.createFolder();
    }

    public boolean createFile() throws IOException {
        File parent = this.file.getParentFile();
        return !(!parent.exists() && !parent.mkdirs() || !this.file.exists() && !this.file.createNewFile());
    }

    public boolean createFolder() throws IOException {
        return this.file.exists() || this.file.mkdirs();
    }

    public boolean copy(Record target) throws IOException {
        return this.copy(target, false);
    }

    public boolean move(Record target) throws IOException {
        return this.copy(target, true);
    }

    private boolean copy(Record target, boolean delete) throws IOException {
        if (target.isFile()) {
            throw new IOException(String.format("Cannot copy '%s' to '%s'", this.path(), target.path()));
        }
        if (this.isDirectory()) {
            Record targetFolder = new Record(target, this.name());
            if (targetFolder.createFolder()) {
                boolean allCopied = true;
                for (Record record : this.children()) {
                    allCopied &= record.copy(targetFolder, delete);
                }
                if (delete && allCopied) {
                    return this.delete();
                }
                return allCopied;
            }
            return false;
        }
        Record targetFile = new Record(target, this.name());
        if (targetFile.createFile()) {
            FileInputStream input = new FileInputStream(this.file);
            FileOutputStream output = new FileOutputStream(targetFile.file);
            Streams.copy(input, output);
            return !delete || this.delete();
        }
        return false;
    }

    public boolean delete() {
        if (this.isFile()) {
            return this.deleteFile();
        }
        return this.deleteFolder();
    }

    public boolean deleteFile() {
        return this.file.exists() && this.file.delete();
    }

    public boolean deleteFolder() {
        return this.file.exists() && this.empty() && this.file.delete();
    }

    public boolean empty() {
        if (this.isFile()) {
            return this.emptyFile();
        }
        return this.emptyFolder();
    }

    public boolean emptyFile() {
        try {
            PrintWriter writer = new PrintWriter(this.file);
            writer.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean emptyFolder() {
        return this.emptyFolder(this.file);
    }

    private boolean emptyFolder(File root) {
        boolean allDeleted = true;
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    allDeleted &= this.emptyFolder(file);
                    allDeleted &= file.delete();
                    continue;
                }
                allDeleted &= file.delete();
            }
        }
        return allDeleted;
    }

    public String string() throws IOException {
        return new String(this.bytes());
    }

    public byte[] bytes() throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");
        byte[] bytes = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(bytes);
        randomAccessFile.close();
        return bytes;
    }

    public boolean write(String content) throws IOException {
        return this.write(content.getBytes("UTF-8"));
    }

    public boolean write(byte[] data) throws IOException {
        if (this.createFile()) {
            try (FileOutputStream outputStream = null;){
                outputStream = new FileOutputStream(this.file);
                outputStream.write(data);
                outputStream.flush();
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.path();
    }
}

