/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.robust.patch.resources.diff.util;

import com.meituan.robust.tools.jbdiff.JBDiff;
import com.meituan.robust.tools.jbdiff.JBPatch;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DiffAndRecoverUtil {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    public static void diff(File oldFile, File newFile, File diffFile) throws IOException {
        JBDiff.bsdiff(oldFile, newFile, diffFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recover(InputStream oldInputStream, InputStream diffInputStream, File newFile) throws IOException {
        if (oldInputStream == null) {
            throw new IOException("old input stream is null");
        }
        if (newFile == null) {
            throw new IOException("new file is null");
        }
        if (diffInputStream == null) {
            throw new IOException("diff input stream is null");
        }
        byte[] oldBytes = DiffAndRecoverUtil.toByteArray(oldInputStream);
        byte[] diffBytes = DiffAndRecoverUtil.toByteArray(diffInputStream);
        if (newFile.exists()) {
            newFile.delete();
        }
        byte[] newBytes = JBPatch.bspatch(oldBytes, oldBytes.length, diffBytes, diffBytes.length);
        try (FileOutputStream newOutputStream = new FileOutputStream(newFile);){
            ((OutputStream)newOutputStream).write(newBytes);
        }
    }

    public static void recover(File baseFile, File diffFile, File newFile) {
        if (null == baseFile || null == diffFile || null == newFile) {
            return;
        }
        if (!baseFile.exists() || !diffFile.exists()) {
            return;
        }
        if (newFile.exists()) {
            newFile.delete();
        }
        try {
            FileInputStream inputStreamBase = new FileInputStream(baseFile);
            FileInputStream inputStreamDiff = new FileInputStream(diffFile);
            DiffAndRecoverUtil.recover(inputStreamBase, inputStreamDiff, newFile);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DiffAndRecoverUtil.copy(input, output);
        return output.toByteArray();
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        long count = DiffAndRecoverUtil.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return DiffAndRecoverUtil.copyLarge(input, output, new byte[4096]);
    }

    private static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

