/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.robust.tools.jbdiff;

import com.meituan.robust.tools.jbdiff.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;

public class JBPatch {
    public static void main(String[] arg) throws IOException {
        if (arg.length != 3) {
            System.err.println("usage example: java -Xmx200m ie.wombat.jbdiff.JBPatch oldfile newfile patchfile");
        }
        File oldFile = new File(arg[0]);
        File newFile = new File(arg[1]);
        File diffFile = new File(arg[2]);
        JBPatch.bspatch(oldFile, newFile, diffFile);
    }

    public static void bspatch(File oldFile, File newFile, File diffFile) throws IOException {
        BufferedInputStream oldInputStream = new BufferedInputStream(new FileInputStream(oldFile));
        byte[] diffBytes = new byte[(int)diffFile.length()];
        FileInputStream diffInputStream = new FileInputStream(diffFile);
        Util.readFromStream(diffInputStream, diffBytes, 0, diffBytes.length);
        byte[] newBytes = JBPatch.bspatch(oldInputStream, (int)oldFile.length(), diffBytes);
        FileOutputStream newOutputStream = new FileOutputStream(newFile);
        ((OutputStream)newOutputStream).write(newBytes);
        ((OutputStream)newOutputStream).close();
    }

    public static byte[] bspatch(InputStream oldInputStream, int oldsize, byte[] diffBytes) throws IOException {
        byte[] oldBuf = new byte[oldsize];
        Util.readFromStream(oldInputStream, oldBuf, 0, oldsize);
        oldInputStream.close();
        return JBPatch.bspatch(oldBuf, oldsize, diffBytes);
    }

    public static byte[] bspatch(byte[] oldBuf, int oldsize, byte[] diffBytes) throws IOException {
        return JBPatch.bspatch(oldBuf, oldsize, diffBytes, diffBytes.length);
    }

    public static byte[] bspatch(byte[] oldBuf, int oldsize, byte[] diffBuf, int diffSize) throws IOException {
        DataInputStream diffIn = new DataInputStream(new ByteArrayInputStream(diffBuf, 0, diffSize));
        diffIn.skip(8L);
        long ctrlBlockLen = diffIn.readLong();
        long diffBlockLen = diffIn.readLong();
        int newsize = (int)diffIn.readLong();
        ByteArrayInputStream in = new ByteArrayInputStream(diffBuf, 0, diffSize);
        ((InputStream)in).skip(32L);
        DataInputStream ctrlBlockIn = new DataInputStream(new GZIPInputStream(in));
        in = new ByteArrayInputStream(diffBuf, 0, diffSize);
        ((InputStream)in).skip(ctrlBlockLen + 32L);
        GZIPInputStream diffBlockIn = new GZIPInputStream(in);
        in = new ByteArrayInputStream(diffBuf, 0, diffSize);
        ((InputStream)in).skip(diffBlockLen + ctrlBlockLen + 32L);
        GZIPInputStream extraBlockIn = new GZIPInputStream(in);
        byte[] newBuf = new byte[newsize];
        int oldpos = 0;
        int newpos = 0;
        int[] ctrl = new int[3];
        while (newpos < newsize) {
            int i;
            for (i = 0; i <= 2; ++i) {
                ctrl[i] = ctrlBlockIn.readInt();
            }
            if (newpos + ctrl[0] > newsize) {
                throw new IOException("Corrupt patch.");
            }
            Util.readFromStream(diffBlockIn, newBuf, newpos, ctrl[0]);
            for (i = 0; i < ctrl[0]; ++i) {
                if (oldpos + i < 0 || oldpos + i >= oldsize) continue;
                int n = newpos + i;
                newBuf[n] = (byte)(newBuf[n] + oldBuf[oldpos + i]);
            }
            oldpos += ctrl[0];
            if ((newpos += ctrl[0]) + ctrl[1] > newsize) {
                throw new IOException("Corrupt patch.");
            }
            Util.readFromStream(extraBlockIn, newBuf, newpos, ctrl[1]);
            newpos += ctrl[1];
            oldpos += ctrl[2];
        }
        ctrlBlockIn.close();
        ((InputStream)diffBlockIn).close();
        ((InputStream)extraBlockIn).close();
        diffIn.close();
        return newBuf;
    }
}

