/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.robust.tools.jbdiff;

import com.meituan.robust.tools.jbdiff.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class JBDiff {
    private static final byte[] MAGIC_BYTES = new byte[]{106, 98, 100, 105, 102, 102, 52, 48};

    private static final void split(int[] I, int[] V, int start, int len, int h) {
        int tmp;
        int i;
        if (len < 16) {
            int j;
            for (int k = start; k < start + len; k += j) {
                j = 1;
                int x = V[I[k] + h];
                int i2 = 1;
                while (k + i2 < start + len) {
                    if (V[I[k + i2] + h] < x) {
                        x = V[I[k + i2] + h];
                        j = 0;
                    }
                    if (V[I[k + i2] + h] == x) {
                        int tmp2 = I[k + j];
                        I[k + j] = I[k + i2];
                        I[k + i2] = tmp2;
                        ++j;
                    }
                    ++i2;
                }
                for (i2 = 0; i2 < j; ++i2) {
                    V[I[k + i2]] = k + j - 1;
                }
                if (j != 1) continue;
                I[k] = -1;
            }
            return;
        }
        int x = V[I[start + len / 2] + h];
        int jj = 0;
        int kk = 0;
        for (i = start; i < start + len; ++i) {
            if (V[I[i] + h] < x) {
                ++jj;
            }
            if (V[I[i] + h] != x) continue;
            ++kk;
        }
        kk += (jj += start);
        i = start;
        int j = 0;
        int k = 0;
        while (i < jj) {
            if (V[I[i] + h] < x) {
                ++i;
                continue;
            }
            if (V[I[i] + h] == x) {
                tmp = I[i];
                I[i] = I[jj + j];
                I[jj + j] = tmp;
                ++j;
                continue;
            }
            tmp = I[i];
            I[i] = I[kk + k];
            I[kk + k] = tmp;
            ++k;
        }
        while (jj + j < kk) {
            if (V[I[jj + j] + h] == x) {
                ++j;
                continue;
            }
            tmp = I[jj + j];
            I[jj + j] = I[kk + k];
            I[kk + k] = tmp;
            ++k;
        }
        if (jj > start) {
            JBDiff.split(I, V, start, jj - start, h);
        }
        for (i = 0; i < kk - jj; ++i) {
            V[I[jj + i]] = kk - 1;
        }
        if (jj == kk - 1) {
            I[jj] = -1;
        }
        if (start + len > kk) {
            JBDiff.split(I, V, kk, start + len - kk, h);
        }
    }

    private static void qsufsort(int[] I, int[] V, byte[] oldBuf, int oldsize) {
        int i;
        int[] buckets = new int[256];
        for (i = 0; i < oldsize; ++i) {
            int n = oldBuf[i] & 0xFF;
            buckets[n] = buckets[n] + 1;
        }
        for (i = 1; i < 256; ++i) {
            int n = i;
            buckets[n] = buckets[n] + buckets[i - 1];
        }
        for (i = 255; i > 0; --i) {
            buckets[i] = buckets[i - 1];
        }
        buckets[0] = 0;
        i = 0;
        while (i < oldsize) {
            int n = oldBuf[i] & 0xFF;
            int n2 = buckets[n] + 1;
            buckets[n] = n2;
            I[n2] = i++;
        }
        I[0] = oldsize;
        for (i = 0; i < oldsize; ++i) {
            V[i] = buckets[oldBuf[i] & 0xFF];
        }
        V[oldsize] = 0;
        for (i = 1; i < 256; ++i) {
            if (buckets[i] != buckets[i - 1] + 1) continue;
            I[buckets[i]] = -1;
        }
        I[0] = -1;
        int h = 1;
        while (I[0] != -(oldsize + 1)) {
            int len = 0;
            int i2 = 0;
            while (i2 < oldsize + 1) {
                if (I[i2] < 0) {
                    len -= I[i2];
                    i2 -= I[i2];
                    continue;
                }
                if (len != 0) {
                    I[i2 - len] = -len;
                }
                len = V[I[i2]] + 1 - i2;
                JBDiff.split(I, V, i2, len, h);
                i2 += len;
                len = 0;
            }
            if (len != 0) {
                I[i2 - len] = -len;
            }
            h += h;
        }
        for (i = 0; i < oldsize + 1; ++i) {
            I[V[i]] = i;
        }
    }

    private static final int matchlen(byte[] oldBuf, int oldSize, int oldOffset, byte[] newBuf, int newSize, int newOffset) {
        int end = Math.min(oldSize - oldOffset, newSize - newOffset);
        for (int i = 0; i < end; ++i) {
            if (oldBuf[oldOffset + i] == newBuf[newOffset + i]) continue;
            return i;
        }
        return end;
    }

    private static final int search(int[] I, byte[] oldBuf, int oldSize, byte[] newBuf, int newSize, int newBufOffset, int start, int end, IntByRef pos) {
        if (end - start < 2) {
            int y;
            int x = JBDiff.matchlen(oldBuf, oldSize, I[start], newBuf, newSize, newBufOffset);
            if (x > (y = JBDiff.matchlen(oldBuf, oldSize, I[end], newBuf, newSize, newBufOffset))) {
                pos.value = I[start];
                return x;
            }
            pos.value = I[end];
            return y;
        }
        int x = start + (end - start) / 2;
        if (Util.memcmp(oldBuf, oldSize, I[x], newBuf, newSize, newBufOffset) < 0) {
            return JBDiff.search(I, oldBuf, oldSize, newBuf, newSize, newBufOffset, x, end, pos);
        }
        return JBDiff.search(I, oldBuf, oldSize, newBuf, newSize, newBufOffset, start, x, pos);
    }

    public static void bsdiff(File oldFile, File newFile, File diffFile) throws IOException {
        BufferedInputStream oldInputStream = new BufferedInputStream(new FileInputStream(oldFile));
        BufferedInputStream newInputStream = new BufferedInputStream(new FileInputStream(newFile));
        FileOutputStream diffOutputStream = new FileOutputStream(diffFile);
        byte[] diffBytes = JBDiff.bsdiff(oldInputStream, (int)oldFile.length(), newInputStream, (int)newFile.length());
        ((OutputStream)diffOutputStream).write(diffBytes);
        ((OutputStream)diffOutputStream).close();
    }

    public static byte[] bsdiff(InputStream oldInputStream, int oldsize, InputStream newInputStream, int newsize) throws IOException {
        byte[] oldBuf = new byte[oldsize];
        Util.readFromStream(oldInputStream, oldBuf, 0, oldsize);
        oldInputStream.close();
        byte[] newBuf = new byte[newsize];
        Util.readFromStream(newInputStream, newBuf, 0, newsize);
        newInputStream.close();
        return JBDiff.bsdiff(oldBuf, oldsize, newBuf, newsize);
    }

    public static byte[] bsdiff(byte[] oldBuf, int oldsize, byte[] newBuf, int newsize) throws IOException {
        int[] I = new int[oldsize + 1];
        JBDiff.qsufsort(I, new int[oldsize + 1], oldBuf, oldsize);
        int dblen = 0;
        byte[] db = new byte[newsize];
        int eblen = 0;
        byte[] eb = new byte[newsize];
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream diffOut = new DataOutputStream(byteOut);
        diffOut.write(MAGIC_BYTES);
        diffOut.writeLong(-1L);
        diffOut.writeLong(-1L);
        diffOut.writeLong(newsize);
        diffOut.flush();
        GZIPOutputStream bzip2Out = new GZIPOutputStream(diffOut);
        DataOutputStream dataOut = new DataOutputStream(bzip2Out);
        int scan = 0;
        int len = 0;
        int lastscan = 0;
        int lastpos = 0;
        int lastoffset = 0;
        IntByRef pos = new IntByRef();
        while (scan < newsize) {
            int oldscore = 0;
            int scsc = scan += len;
            while (scan < newsize) {
                len = JBDiff.search(I, oldBuf, oldsize, newBuf, newsize, scan, 0, oldsize, pos);
                while (scsc < scan + len) {
                    if (scsc + lastoffset < oldsize && oldBuf[scsc + lastoffset] == newBuf[scsc]) {
                        ++oldscore;
                    }
                    ++scsc;
                }
                if (len == oldscore && len != 0 || len > oldscore + 8) break;
                if (scan + lastoffset < oldsize && oldBuf[scan + lastoffset] == newBuf[scan]) {
                    --oldscore;
                }
                ++scan;
            }
            if (len == oldscore && scan != newsize) continue;
            int s = 0;
            int Sf = 0;
            int lenf = 0;
            int i = 0;
            while (lastscan + i < scan && lastpos + i < oldsize) {
                if (oldBuf[lastpos + i] == newBuf[lastscan + i]) {
                    ++s;
                }
                if (s * 2 - ++i <= Sf * 2 - lenf) continue;
                Sf = s;
                lenf = i;
            }
            int lenb = 0;
            if (scan < newsize) {
                s = 0;
                int Sb = 0;
                for (i = 1; scan >= lastscan + i && pos.value >= i; ++i) {
                    if (oldBuf[pos.value - i] == newBuf[scan - i]) {
                        ++s;
                    }
                    if (s * 2 - i <= Sb * 2 - lenb) continue;
                    Sb = s;
                    lenb = i;
                }
            }
            if (lastscan + lenf > scan - lenb) {
                int overlap = lastscan + lenf - (scan - lenb);
                s = 0;
                int Ss = 0;
                int lens = 0;
                for (i = 0; i < overlap; ++i) {
                    if (newBuf[lastscan + lenf - overlap + i] == oldBuf[lastpos + lenf - overlap + i]) {
                        ++s;
                    }
                    if (newBuf[scan - lenb + i] == oldBuf[pos.value - lenb + i]) {
                        --s;
                    }
                    if (s <= Ss) continue;
                    Ss = s;
                    lens = i + 1;
                }
                lenf += lens - overlap;
                lenb -= lens;
            }
            for (i = 0; i < lenf; ++i) {
                db[dblen + i] = (byte)(newBuf[lastscan + i] - oldBuf[lastpos + i]);
            }
            for (i = 0; i < scan - lenb - (lastscan + lenf); ++i) {
                eb[eblen + i] = newBuf[lastscan + lenf + i];
            }
            dblen += lenf;
            eblen += scan - lenb - (lastscan + lenf);
            dataOut.writeInt(lenf);
            dataOut.writeInt(scan - lenb - (lastscan + lenf));
            dataOut.writeInt(pos.value - lenb - (lastpos + lenf));
            lastscan = scan - lenb;
            lastpos = pos.value - lenb;
            lastoffset = pos.value - scan;
        }
        dataOut.flush();
        bzip2Out.finish();
        int ctrlBlockLen = diffOut.size() - 32;
        bzip2Out = new GZIPOutputStream(diffOut);
        bzip2Out.write(db, 0, dblen);
        bzip2Out.finish();
        bzip2Out.flush();
        int diffBlockLen = diffOut.size() - ctrlBlockLen - 32;
        bzip2Out = new GZIPOutputStream(diffOut);
        bzip2Out.write(eb, 0, eblen);
        bzip2Out.finish();
        bzip2Out.flush();
        diffOut.close();
        ByteArrayOutputStream byteHeaderOut = new ByteArrayOutputStream(32);
        DataOutputStream headerOut = new DataOutputStream(byteHeaderOut);
        headerOut.write(MAGIC_BYTES);
        headerOut.writeLong(ctrlBlockLen);
        headerOut.writeLong(diffBlockLen);
        headerOut.writeLong(newsize);
        headerOut.close();
        byte[] diffBytes = byteOut.toByteArray();
        byte[] headerBytes = byteHeaderOut.toByteArray();
        System.arraycopy(headerBytes, 0, diffBytes, 0, headerBytes.length);
        return diffBytes;
    }

    public static void main(String[] arg) throws IOException {
        if (arg.length != 3) {
            System.err.println("usage example: java -Xmx200m ie.wombat.jbdiff.JBDiff oldfile newfile patchfile\n");
            return;
        }
        File oldFile = new File(arg[0]);
        File newFile = new File(arg[1]);
        File diffFile = new File(arg[2]);
        JBDiff.bsdiff(oldFile, newFile, diffFile);
    }

    private static class IntByRef {
        private int value;

        private IntByRef() {
        }
    }
}

