/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.robust.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipOperation {
    private static final int BUFFER_SIZE = 8192;

    public static void zipFiles(Collection<File> resFileList, File zipFile) throws IOException {
        ZipOutputStream zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 8192));
        for (File resFile : resFileList) {
            if (!resFile.exists()) continue;
            ZipOperation.zipFile(resFile, zipout, "");
        }
        zipout.close();
    }

    private static void zipFile(File resFile, ZipOutputStream zipout, String rootpath) throws IOException {
        rootpath = rootpath + (rootpath.trim().length() == 0 ? "" : File.separator) + resFile.getName();
        if (resFile.isDirectory()) {
            File[] fileList;
            for (File file : fileList = resFile.listFiles()) {
                ZipOperation.zipFile(file, zipout, rootpath);
            }
        } else {
            byte[] fileContents = ZipOperation.readContents(resFile);
            if (rootpath.contains("\\")) {
                rootpath = rootpath.replace("\\", "/");
            }
            ZipEntry entry = new ZipEntry(rootpath);
            entry.setMethod(8);
            zipout.putNextEntry(entry);
            zipout.write(fileContents);
            zipout.flush();
            zipout.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readContents(File file) throws IOException {
        int bufferSize = 8192;
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int length;
            FileInputStream in = new FileInputStream(file);
            BufferedInputStream bIn = new BufferedInputStream(in);
            byte[] buffer = new byte[8192];
            while ((length = bIn.read(buffer, 0, 8192)) != -1) {
                byte[] bufferCopy = new byte[length];
                System.arraycopy(buffer, 0, bufferCopy, 0, length);
                output.write(bufferCopy);
            }
            bIn.close();
        }
        return output.toByteArray();
    }

    public static void zipInputDir(File inputDir, File outputFile) throws IOException {
        File[] unzipFiles = inputDir.listFiles();
        ArrayList<File> collectFiles = new ArrayList<File>();
        for (File f : unzipFiles) {
            collectFiles.add(f);
        }
        ZipOperation.zipFiles(collectFiles, outputFile);
    }
}

