/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.robust.utils;

import com.meituan.robust.common.TxtFileReaderAndWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;

public class RobustLog {
    private static String logPath;

    public static void log(String exceptionName, Throwable throwable) {
        String line1 = exceptionName + ":";
        String line2 = RobustLog.getStackTraceString(throwable);
        System.err.println("robust log -> " + line1);
        System.err.println(line2);
        RobustLog.write2FileLineByLine(line1);
        RobustLog.write2FileLineByLine(line2);
    }

    public static void log(String info) {
        String line = info + "";
        System.err.println("robust log -> " + line);
        RobustLog.write2FileLineByLine(line);
    }

    public static void setRobustLogFilePath(String path) {
        logPath = path;
    }

    public static void write2FileLineByLine(String line) {
        String readString;
        if (null == logPath || "".equals(logPath)) {
            return;
        }
        String writeString = line;
        if (new File(logPath).exists() && null != (readString = TxtFileReaderAndWriter.readFileAsString(logPath)) && !"".equals(readString)) {
            writeString = readString + "\n" + writeString;
        }
        TxtFileReaderAndWriter.writeFile(logPath, writeString);
    }

    private static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

