/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.robust.resource.diff;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.meituan.robust.common.FileUtil;
import com.meituan.robust.common.TxtFileReaderAndWriter;
import com.meituan.robust.resource.diff.data.APKDiffData;
import com.meituan.robust.resource.diff.data.DataUnit;
import java.io.File;
import java.lang.reflect.Type;

public class ApkDiffDataReaderAndWriter {
    private static final Type TYPE = new TypeToken<APKDiffData>(){}.getType();
    private static Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();

    public static APKDiffData readDiffData(File file) {
        if (null == file || !file.exists()) {
            return null;
        }
        String json = TxtFileReaderAndWriter.readFileAsString(file);
        if (null == json || json.length() == 0) {
            return null;
        }
        return (APKDiffData)gson.fromJson(json, TYPE);
    }

    public static void main(String[] args) {
        String diif_data_path = "/Users/hedingxu/robust-github/Robust/app/resource_diff_data.robust_tmp";
        APKDiffData oldDiffdata = new APKDiffData();
        oldDiffdata.oldResourcesArscCrc = 3372233974L;
        oldDiffdata.diffTypeName = "apk";
        DataUnit dd = new DataUnit();
        dd.name = "resources.arsc";
        dd.newCrc = 2912363016L;
        dd.newMd5 = "e2a7e2d8469e1b5c2d4b5688bba80bc2";
        dd.diffMd5 = "a8e134e31c06122cfd651989f7759e30";
        dd.oldMd5 = "2a30f769a904a4d103939b83f295de6e";
        oldDiffdata.diffModSet.add(dd);
        ApkDiffDataReaderAndWriter.writeDiffData(new File(diif_data_path), oldDiffdata);
        APKDiffData diffData = ApkDiffDataReaderAndWriter.readDiffData(new File(diif_data_path));
        if (diffData == null) {
            System.err.println("blank ");
        }
    }

    public static boolean writeDiffData(File file, APKDiffData apkDiffData) {
        String apkDiffDataJson = null;
        try {
            apkDiffDataJson = gson.toJson((Object)apkDiffData, TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String content = apkDiffDataJson;
        if (null == file || null == content) {
            return false;
        }
        FileUtil.createFile(file.getAbsolutePath());
        TxtFileReaderAndWriter.writeFile(file, content);
        return true;
    }
}

