/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.fileservices.odata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.fileservices.odata.ODataEntityFetcher;
import com.microsoft.fileservices.odata.ODataExecutable;
import com.microsoft.fileservices.odata.Readable;
import com.microsoft.services.odata.EntityCollectionFetcherHelper;
import com.microsoft.services.odata.EntityFetcherHelper;
import com.microsoft.services.odata.Helpers;
import com.microsoft.services.odata.interfaces.DependencyResolver;
import com.microsoft.services.odata.interfaces.HttpVerb;
import com.microsoft.services.odata.interfaces.ODataURL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ODataCollectionFetcher<T, U, V>
extends ODataExecutable
implements Readable<List<T>> {
    private int top = -1;
    private int skip = -1;
    private String selectedId = null;
    private String urlComponent;
    private ODataExecutable parent;
    private Class<T> clazz;
    private V operations;
    private String select = null;
    private String expand = null;
    private String filter = null;

    public ODataCollectionFetcher(String urlComponent, ODataExecutable parent, Class<T> clazz, Class<V> operationClazz) {
        this.urlComponent = urlComponent;
        this.parent = parent;
        this.clazz = clazz;
        this.reset();
        try {
            this.operations = operationClazz.getConstructor(String.class, ODataExecutable.class).newInstance("", this);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
    }

    public void reset() {
        this.top = -1;
        this.skip = -1;
        this.selectedId = null;
        this.select = null;
        this.expand = null;
        this.filter = null;
    }

    public ODataCollectionFetcher<T, U, V> top(int top) {
        this.top = top;
        return this;
    }

    public ODataCollectionFetcher<T, U, V> skip(int skip) {
        this.skip = skip;
        return this;
    }

    public ODataCollectionFetcher<T, U, V> select(String select) {
        this.select = select;
        return this;
    }

    public ODataCollectionFetcher<T, U, V> expand(String expand) {
        this.expand = expand;
        return this;
    }

    public ODataCollectionFetcher<T, U, V> filter(String filter) {
        this.filter = filter;
        return this;
    }

    public U getById(String id) {
        this.selectedId = id;
        String packageName = this.operations.getClass().getPackage().getName();
        String[] classNameParts = (this.clazz.getCanonicalName() + "Fetcher").split("\\.");
        String className = packageName + "." + classNameParts[classNameParts.length - 1];
        try {
            Class<?> entityQueryClass = Class.forName(className);
            ODataEntityFetcher odataEntityQuery = (ODataEntityFetcher)entityQueryClass.getConstructor(String.class, ODataExecutable.class).newInstance("", this);
            return (U)odataEntityQuery;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    ListenableFuture<byte[]> oDataExecute(ODataURL path, byte[] content, HttpVerb verb, Map<String, String> headers) {
        if (this.selectedId == null) {
            EntityFetcherHelper.setPathForCollections((ODataURL)path, (String)this.urlComponent, (int)this.top, (int)this.skip, (String)this.select, (String)this.expand, (String)this.filter);
        } else {
            EntityFetcherHelper.setSelectorUrl((ODataURL)path, (String)this.urlComponent, (String)this.selectedId);
        }
        Helpers.addCustomParametersToODataURL((ODataURL)path, this.getCustomParameters(), (DependencyResolver)this.getResolver());
        HashMap<String, String> newHeaders = new HashMap<String, String>(this.getCustomHeaders());
        newHeaders.putAll(headers);
        return this.parent.oDataExecute(path, content, verb, newHeaders);
    }

    @Override
    public DependencyResolver getResolver() {
        return this.parent.getResolver();
    }

    @Override
    public ListenableFuture<List<T>> read() {
        SettableFuture result = SettableFuture.create();
        ListenableFuture<byte[]> future = this.oDataExecute(this.getResolver().createODataURL(), null, HttpVerb.GET, this.getCustomHeaders());
        EntityCollectionFetcherHelper.addListResultCallback((SettableFuture)result, future, (DependencyResolver)this.getResolver(), this.clazz);
        return result;
    }

    public ListenableFuture<T> add(T entity) {
        SettableFuture result = SettableFuture.create();
        byte[] payloadBytes = Helpers.serializeToJsonByteArray(entity, (DependencyResolver)this.getResolver());
        ListenableFuture<byte[]> future = this.oDataExecute(this.getResolver().createODataURL(), payloadBytes, HttpVerb.POST, this.getCustomHeaders());
        EntityFetcherHelper.addEntityResultCallback((SettableFuture)result, future, (DependencyResolver)this.getResolver(), this.clazz);
        return result;
    }

    public V getOperations() {
        return this.operations;
    }
}

