/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.odata;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.odata.ODataException;
import com.microsoft.services.odata.ODataExecutable;
import com.microsoft.services.odata.ODataResponseImpl;
import com.microsoft.services.odata.interfaces.Credentials;
import com.microsoft.services.odata.interfaces.DependencyResolver;
import com.microsoft.services.odata.interfaces.HttpTransport;
import com.microsoft.services.odata.interfaces.LogLevel;
import com.microsoft.services.odata.interfaces.Logger;
import com.microsoft.services.odata.interfaces.ODataResponse;
import com.microsoft.services.odata.interfaces.Request;
import com.microsoft.services.odata.interfaces.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public abstract class BaseODataContainer
extends ODataExecutable {
    private String url;
    private DependencyResolver resolver;

    public BaseODataContainer(String url, DependencyResolver resolver) {
        this.url = url;
        this.resolver = resolver;
    }

    @Override
    protected ListenableFuture<ODataResponse> oDataExecute(Request request) {
        final Logger logger = this.resolver.getLogger();
        request.getUrl().setBaseUrl(this.url);
        String fullUrl = request.getUrl().toString();
        String executionInfo = String.format("URL: %s - HTTP VERB: %s", new Object[]{fullUrl, request.getVerb()});
        logger.log("Start preparing OData execution for " + executionInfo, LogLevel.INFO);
        if (request.getContent() != null) {
            logger.log("With " + request.getContent().length + " bytes of payload", LogLevel.INFO);
        }
        HttpTransport httpTransport = this.resolver.getHttpTransport();
        String userAgent = this.resolver.getPlatformUserAgent(this.getClass().getCanonicalName());
        request.addHeader("User-Agent", userAgent);
        request.addHeader("X-ClientService-ClientTag", userAgent);
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Accept", "application/json");
        request.addHeader("OData-Version", "4.0");
        request.addHeader("OData-MaxVersion", "4.0");
        if (request.getHeaders() != null) {
            for (String key : request.getHeaders().keySet()) {
                request.addHeader(key, request.getHeaders().get(key));
            }
        }
        boolean credentialsSet = false;
        Credentials cred = this.resolver.getCredentials();
        if (cred != null) {
            cred.prepareRequest(request);
            credentialsSet = true;
        }
        if (!credentialsSet) {
            logger.log("Executing request without setting credentials", LogLevel.WARNING);
        }
        logger.log("Request Headers: ", LogLevel.VERBOSE);
        for (String key : request.getHeaders().keySet()) {
            logger.log(key + " : " + request.getHeaders().get(key), LogLevel.VERBOSE);
        }
        ListenableFuture<Response> future = httpTransport.execute(request);
        logger.log("OData request executed", LogLevel.INFO);
        final SettableFuture result = SettableFuture.create();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Response>(){

            public void onSuccess(Response response) {
                try {
                    logger.log("OData response received", LogLevel.INFO);
                    logger.log("Reading response data...", LogLevel.VERBOSE);
                    byte[] data = BaseODataContainer.readAllBytes(response.getStream());
                    logger.log(data.length + " bytes read from response", LogLevel.VERBOSE);
                    int status = response.getStatus();
                    logger.log("Response Status Code: " + status, LogLevel.INFO);
                    try {
                        logger.log("Closing response", LogLevel.VERBOSE);
                        response.close();
                    }
                    catch (Throwable t) {
                        logger.log("Error closing response: " + t.toString(), LogLevel.ERROR);
                        result.setException(t);
                        return;
                    }
                    ODataResponseImpl odataResponse = new ODataResponseImpl(data, response);
                    if (status < 200 || status > 299) {
                        logger.log("Invalid status code. Processing response content as String", LogLevel.VERBOSE);
                        String responseData = new String(data, "UTF-8");
                        String message = "Response status: " + response.getStatus() + "\n" + "Response content: " + responseData;
                        logger.log(message, LogLevel.ERROR);
                        result.setException((Throwable)new ODataException((ODataResponse)odataResponse, message));
                        return;
                    }
                    result.set((Object)odataResponse);
                }
                catch (Throwable t) {
                    logger.log("Unexpected error: " + t.toString(), LogLevel.ERROR);
                    ODataResponseImpl odataResponse = new ODataResponseImpl(null, response);
                    result.setException((Throwable)new ODataException((ODataResponse)odataResponse, t));
                }
            }

            public void onFailure(Throwable throwable) {
                result.setException(throwable);
            }
        });
        return result;
    }

    public static byte[] readAllBytes(InputStream stream) throws IOException {
        int nRead;
        if (stream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            os.write(data, 0, nRead);
        }
        return os.toByteArray();
    }

    public static String generateParametersPayload(Map<String, Object> parameters, DependencyResolver resolver) {
        return resolver.getJsonSerializer().serialize(parameters);
    }

    @Override
    protected DependencyResolver getResolver() {
        return this.resolver;
    }
}

