/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.odata;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarSerializer {
    public static Calendar deserialize(String strVal) throws ParseException {
        boolean hasZ = strVal.indexOf(90) != -1;
        String s = hasZ ? strVal.replace("Z", "+0000") : strVal;
        String zsuffix = hasZ ? "Z" : "";
        String datePattern = s.contains(".") ? "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS" + zsuffix : "yyyy-MM-dd'T'HH:mm:ss" + zsuffix;
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        dateFormat.setTimeZone(TimeZone.getDefault());
        Date date = dateFormat.parse(s);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static String serialize(Calendar src) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSSSSS'Z'", Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(src.getTime());
    }
}

