/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.odata;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.odata.Helpers;
import com.microsoft.services.odata.ODataEntityFetcher;
import com.microsoft.services.odata.ODataExecutable;
import com.microsoft.services.odata.ODataFetcher;
import com.microsoft.services.odata.ODataOperations;
import com.microsoft.services.odata.Readable;
import com.microsoft.services.odata.interfaces.HttpVerb;
import com.microsoft.services.odata.interfaces.LogLevel;
import com.microsoft.services.odata.interfaces.ODataResponse;
import com.microsoft.services.odata.interfaces.ODataURL;
import com.microsoft.services.odata.interfaces.Request;
import java.util.List;

public class ODataCollectionFetcher<TEntity, TFetcher extends ODataEntityFetcher, TOperations extends ODataOperations>
extends ODataFetcher<TEntity>
implements Readable<List<TEntity>> {
    private int top = -1;
    private int skip = -1;
    private String selectedId = null;
    private TOperations operations;
    private String select = null;
    private String expand = null;
    private String filter = null;
    private String orderBy = null;

    public ODataCollectionFetcher(String urlComponent, ODataExecutable parent, Class<TEntity> clazz, Class<TOperations> operationClazz) {
        super(urlComponent, parent, clazz);
        this.reset();
        try {
            this.operations = (ODataOperations)operationClazz.getConstructor(String.class, ODataExecutable.class).newInstance("", this);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
    }

    public void reset() {
        this.top = -1;
        this.skip = -1;
        this.selectedId = null;
        this.select = null;
        this.expand = null;
        this.filter = null;
        this.orderBy = null;
    }

    public ODataCollectionFetcher<TEntity, TFetcher, TOperations> top(int top) {
        this.top = top;
        return this;
    }

    public ODataCollectionFetcher<TEntity, TFetcher, TOperations> skip(int skip) {
        this.skip = skip;
        return this;
    }

    public ODataCollectionFetcher<TEntity, TFetcher, TOperations> select(String select) {
        this.select = select;
        return this;
    }

    public ODataCollectionFetcher<TEntity, TFetcher, TOperations> expand(String expand) {
        this.expand = expand;
        return this;
    }

    public ODataCollectionFetcher<TEntity, TFetcher, TOperations> filter(String filter) {
        this.filter = filter;
        return this;
    }

    public ODataCollectionFetcher<TEntity, TFetcher, TOperations> orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public TFetcher getById(String id2) {
        this.selectedId = id2;
        String packageName = this.operations.getClass().getPackage().getName();
        String[] classNameParts = (this.clazz.getCanonicalName() + "Fetcher").split("\\.");
        String className = packageName + "." + classNameParts[classNameParts.length - 1];
        try {
            Class<?> entityQueryClass = Class.forName(className);
            ODataEntityFetcher odataEntityQuery = (ODataEntityFetcher)entityQueryClass.getConstructor(String.class, ODataExecutable.class).newInstance("", this);
            return (TFetcher)odataEntityQuery;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ListenableFuture<ODataResponse> oDataExecute(Request request) {
        if (this.selectedId == null) {
            this.setPathForCollections(request.getUrl(), this.urlComponent, this.top, this.skip, this.select, this.expand, this.filter, this.orderBy);
        } else {
            this.setSelectorUrl(request.getUrl(), this.urlComponent, this.selectedId);
        }
        Helpers.addCustomParametersToODataRequest(request, this.getParameters(), this.getHeaders());
        return this.parent.oDataExecute(request);
    }

    @Override
    public ListenableFuture<List<TEntity>> read() {
        SettableFuture result = SettableFuture.create();
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.GET);
        ListenableFuture<ODataResponse> future = this.oDataExecute(request);
        this.addListResultCallback(result, future);
        return result;
    }

    public ListenableFuture<TEntity> add(TEntity entity) {
        SettableFuture result = SettableFuture.create();
        byte[] payloadBytes = Helpers.serializeToJsonByteArray(entity, this.getResolver());
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        request.setContent(payloadBytes);
        ListenableFuture<ODataResponse> future = this.oDataExecute(request);
        this.addEntityResultCallback(result, future);
        return result;
    }

    public TOperations getOperations() {
        return this.operations;
    }

    public ODataCollectionFetcher<TEntity, TFetcher, TOperations> addParameter(String name, Object value) {
        this.addCustomParameter(name, value);
        return this;
    }

    public ODataCollectionFetcher<TEntity, TFetcher, TOperations> addHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public void addListResultCallback(final SettableFuture<List<TEntity>> result, ListenableFuture<ODataResponse> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<ODataResponse>(){

            public void onSuccess(ODataResponse payload) {
                try {
                    ODataCollectionFetcher.this.log("Entity collection Deserialization Started", LogLevel.VERBOSE);
                    String string2 = new String(payload.getPayload(), "UTF-8");
                    List list = ODataCollectionFetcher.this.getResolver().getJsonSerializer().deserializeList(string2, ODataCollectionFetcher.this.clazz);
                    ODataCollectionFetcher.this.log("Entity collection Deserialization Finished", LogLevel.VERBOSE);
                    result.set(list);
                }
                catch (Throwable e) {
                    result.setException(e);
                }
            }

            public void onFailure(Throwable throwable) {
                result.setException(throwable);
            }
        });
    }

    protected void setPathForCollections(ODataURL url, String urlComponent, int top, int skip, String select, String expand, String filter, String orderBy) {
        if (top > -1) {
            url.addQueryStringParameter("$top", Integer.valueOf(top).toString());
        }
        if (skip > -1) {
            url.addQueryStringParameter("$skip", Integer.valueOf(skip).toString());
        }
        if (select != null) {
            url.addQueryStringParameter("$select", select);
        }
        if (expand != null) {
            url.addQueryStringParameter("$expand", expand);
        }
        if (filter != null) {
            url.addQueryStringParameter("$filter", filter);
        }
        if (orderBy != null) {
            url.addQueryStringParameter("$orderby", orderBy);
        }
        url.prependPathComponent(urlComponent);
    }
}

