/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.odata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.odata.Helpers;
import com.microsoft.services.odata.ODataExecutable;
import com.microsoft.services.odata.ODataFetcher;
import com.microsoft.services.odata.ODataOperations;
import com.microsoft.services.odata.Readable;
import com.microsoft.services.odata.interfaces.HttpVerb;
import com.microsoft.services.odata.interfaces.ODataResponse;
import com.microsoft.services.odata.interfaces.ODataURL;
import com.microsoft.services.odata.interfaces.Request;

public abstract class ODataEntityFetcher<TEntity, TOperations extends ODataOperations>
extends ODataFetcher<TEntity>
implements Readable<TEntity> {
    private TOperations operations;
    private String select;
    private String expand;

    public ODataEntityFetcher(String urlComponent, ODataExecutable parent, Class<TEntity> clazz, Class<TOperations> operationClazz) {
        super(urlComponent, parent, clazz);
        try {
            this.operations = (ODataOperations)operationClazz.getConstructor(String.class, ODataExecutable.class).newInstance("", this);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
    }

    @Override
    protected ListenableFuture<ODataResponse> oDataExecute(Request request) {
        ODataURL oDataURL = request.getUrl();
        if (this.select != null) {
            oDataURL.addQueryStringParameter("$select", this.select);
        }
        if (this.expand != null) {
            oDataURL.addQueryStringParameter("$expand", this.expand);
        }
        oDataURL.prependPathComponent(this.urlComponent);
        Helpers.addCustomParametersToODataRequest(request, this.getParameters(), this.getHeaders());
        return this.parent.oDataExecute(request);
    }

    public ListenableFuture<TEntity> update(TEntity updatedEntity) {
        SettableFuture result = SettableFuture.create();
        byte[] payloadBytes = Helpers.serializeToJsonByteArray(updatedEntity, this.getResolver());
        Request request = this.getResolver().createRequest();
        request.setContent(payloadBytes);
        request.setVerb(HttpVerb.PATCH);
        ListenableFuture<ODataResponse> future = this.oDataExecute(request);
        this.addEntityResultCallback(result, future);
        return result;
    }

    public ListenableFuture delete() {
        SettableFuture result = SettableFuture.create();
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.DELETE);
        ListenableFuture<ODataResponse> future = this.oDataExecute(request);
        this.addNullResultCallback(result, future);
        return result;
    }

    @Override
    public ListenableFuture<TEntity> read() {
        SettableFuture result = SettableFuture.create();
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.GET);
        ListenableFuture<ODataResponse> future = this.oDataExecute(request);
        this.addEntityResultCallback(result, future);
        return result;
    }

    public ODataEntityFetcher<TEntity, TOperations> select(String select) {
        this.select = select;
        return this;
    }

    public ODataEntityFetcher<TEntity, TOperations> expand(String expand) {
        this.expand = expand;
        return this;
    }

    public TOperations getOperations() {
        return this.operations;
    }
}

