/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.odata;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.odata.ODataExecutable;
import com.microsoft.services.odata.interfaces.DependencyResolver;
import com.microsoft.services.odata.interfaces.LogLevel;
import com.microsoft.services.odata.interfaces.ODataResponse;
import com.microsoft.services.odata.interfaces.ODataURL;

public abstract class ODataFetcher<TEntity>
extends ODataExecutable {
    protected Class<TEntity> clazz;
    protected String urlComponent;
    protected ODataExecutable parent;

    public ODataFetcher(String urlComponent, ODataExecutable parent, Class<TEntity> clazz) {
        this.clazz = clazz;
        this.urlComponent = urlComponent;
        this.parent = parent;
    }

    @Override
    protected DependencyResolver getResolver() {
        return this.parent.getResolver();
    }

    protected void addEntityResultCallback(final SettableFuture<TEntity> result, ListenableFuture<ODataResponse> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<ODataResponse>(){

            public void onSuccess(ODataResponse response) {
                try {
                    ODataFetcher.this.log("Entity Deserialization Started", LogLevel.VERBOSE);
                    String string2 = new String(response.getPayload(), "UTF-8");
                    Object entity = ODataFetcher.this.getResolver().getJsonSerializer().deserialize(string2, ODataFetcher.this.clazz);
                    ODataFetcher.this.log("Entity Deserialization Finished", LogLevel.VERBOSE);
                    result.set(entity);
                }
                catch (Throwable e) {
                    result.setException(e);
                }
            }

            public void onFailure(Throwable throwable) {
                result.setException(throwable);
            }
        });
    }

    protected void addByteArrayResultCallback(final SettableFuture<byte[]> result, ListenableFuture<byte[]> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<byte[]>(){

            public void onSuccess(byte[] payload) {
                try {
                    result.set((Object)payload);
                }
                catch (Throwable e) {
                    result.setException(e);
                }
            }

            public void onFailure(Throwable throwable) {
                result.setException(throwable);
            }
        });
    }

    protected void addNullResultCallback(final SettableFuture<?> result, ListenableFuture<ODataResponse> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<ODataResponse>(){

            public void onSuccess(ODataResponse response) {
                result.set(null);
            }

            public void onFailure(Throwable throwable) {
                result.setException(throwable);
            }
        });
    }

    protected void setSelectorUrl(ODataURL url, String urlComponent, String selectedId) {
        String selector = "('" + selectedId + "')";
        url.prependPathComponent(urlComponent + selector);
    }
}

