/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.odata;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.odata.ODataEntityFetcher;
import com.microsoft.services.odata.ODataExecutable;
import com.microsoft.services.odata.ODataOperations;
import com.microsoft.services.odata.Readable;
import com.microsoft.services.odata.interfaces.HttpVerb;
import com.microsoft.services.odata.interfaces.ODataResponse;
import com.microsoft.services.odata.interfaces.ODataURL;
import com.microsoft.services.odata.interfaces.Request;

public abstract class ODataMediaEntityFetcher<TEntity, TOperations extends ODataOperations>
extends ODataEntityFetcher<TEntity, TOperations>
implements Readable<TEntity> {
    public ODataMediaEntityFetcher(String urlComponent, ODataExecutable parent, Class<TEntity> clazz, Class<TOperations> operationClazz) {
        super(urlComponent, parent, clazz, operationClazz);
    }

    public ListenableFuture<byte[]> getContent() {
        final SettableFuture result = SettableFuture.create();
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.GET);
        ODataURL url = request.getUrl();
        url.appendPathComponent("$value");
        ListenableFuture<ODataResponse> future = this.oDataExecute(request);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<ODataResponse>(){

            public void onSuccess(ODataResponse response) {
                result.set((Object)response.getPayload());
            }

            public void onFailure(Throwable t) {
                result.setException(t);
            }
        });
        return result;
    }

    public ListenableFuture<Void> putContent(byte[] content) {
        Request request = this.getResolver().createRequest();
        request.setContent(content);
        request.setVerb(HttpVerb.PUT);
        ODataURL url = request.getUrl();
        url.appendPathComponent("$value");
        ListenableFuture<ODataResponse> future = this.oDataExecute(request);
        SettableFuture result = SettableFuture.create();
        this.addNullResultCallback(result, future);
        return result;
    }
}

