/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.odata;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.odata.Helpers;
import com.microsoft.services.odata.ODataExecutable;
import com.microsoft.services.odata.interfaces.DependencyResolver;
import com.microsoft.services.odata.interfaces.LogLevel;
import com.microsoft.services.odata.interfaces.ODataResponse;
import com.microsoft.services.odata.interfaces.Request;

public abstract class ODataOperations
extends ODataExecutable {
    private String urlComponent;
    private ODataExecutable parent;

    public ODataOperations(String urlComponent, ODataExecutable parent) {
        this.urlComponent = urlComponent;
        this.parent = parent;
    }

    @Override
    protected ListenableFuture<ODataResponse> oDataExecute(Request request) {
        request.getUrl().prependPathComponent(this.urlComponent);
        Helpers.addCustomParametersToODataRequest(request, this.getParameters(), this.getHeaders());
        return this.parent.oDataExecute(request);
    }

    public <TEntity> void addEntityResultCallback(final SettableFuture<TEntity> result, ListenableFuture<ODataResponse> future, final Class<TEntity> clazz) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<ODataResponse>(){

            public void onSuccess(ODataResponse response) {
                try {
                    ODataOperations.this.log("Entity Deserialization Started", LogLevel.VERBOSE);
                    String string2 = new String(response.getPayload(), "UTF-8");
                    Object entity = ODataOperations.this.getResolver().getJsonSerializer().deserialize(string2, clazz);
                    ODataOperations.this.log("Entity Deserialization Finished", LogLevel.VERBOSE);
                    result.set(entity);
                }
                catch (Throwable e) {
                    result.setException(e);
                }
            }

            public void onFailure(Throwable throwable) {
                result.setException(throwable);
            }
        });
    }

    @Override
    protected DependencyResolver getResolver() {
        return this.parent.getResolver();
    }
}

