/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.odata.impl;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.microsoft.services.odata.Helpers;
import com.microsoft.services.odata.impl.ByteArrayTypeAdapterBase;
import com.microsoft.services.odata.impl.CalendarTypeAdapter;
import com.microsoft.services.odata.interfaces.JsonSerializer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GsonSerializerBase
implements JsonSerializer {
    private static Map<String, Class<?>> cachedClassesFromOData = new ConcurrentHashMap();

    private Gson createGson() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).registerTypeAdapter(Calendar.class, (Object)new CalendarTypeAdapter()).registerTypeAdapter(GregorianCalendar.class, (Object)new CalendarTypeAdapter()).registerTypeAdapter(byte[].class, (Object)this.getByteArrayTypeAdapter()).create();
    }

    protected abstract ByteArrayTypeAdapterBase getByteArrayTypeAdapter();

    @Override
    public String serialize(Object objectToSerialize) {
        Gson serializer = this.createGson();
        JsonElement json = serializer.toJsonTree(objectToSerialize);
        this.sanitizePostSerialization(json);
        return json.toString();
    }

    @Override
    public <E> E deserialize(String payload, Class<E> clazz) {
        Gson serializer = this.createGson();
        JsonParser parser = new JsonParser();
        JsonElement json = parser.parse(payload);
        this.sanitizeForDeserialization(json);
        Package pkg = clazz.getPackage();
        Class overridenClass = this.getClassFromJson(json, pkg);
        if (overridenClass != null) {
            clazz = overridenClass;
        }
        return (E)serializer.fromJson(json, clazz);
    }

    protected Class getClassFromJson(JsonElement json, Package pkg) {
        try {
            JsonObject jsonObject;
            if (json.isJsonObject() && (jsonObject = json.getAsJsonObject()).has("$$__ODataType")) {
                String dataType = jsonObject.get("$$__ODataType").getAsString();
                if (cachedClassesFromOData.containsKey(dataType)) {
                    return cachedClassesFromOData.get(dataType);
                }
                String[] parts = dataType.split("\\.");
                String className = parts[parts.length - 1];
                String classFullName = pkg.getName() + "." + className;
                Class<?> derivedClass = Class.forName(classFullName);
                Class<?> baseClass = Class.forName(pkg.getName() + "." + "ODataBaseEntity");
                Object instance = derivedClass.newInstance();
                Field field = baseClass.getDeclaredField("$$__ODataType");
                if (field != null) {
                    field.setAccessible(true);
                    String val = (String)field.get(instance);
                    if (val.equals(dataType)) {
                        cachedClassesFromOData.put(dataType, derivedClass);
                        return derivedClass;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public <E> List<E> deserializeList(String payload, Class<E> clazz) {
        Gson serializer = this.createGson();
        JsonParser parser = new JsonParser();
        JsonObject json = (JsonObject)parser.parse(payload);
        JsonElement jsonArray = json.get("value");
        this.sanitizeForDeserialization(jsonArray);
        Package pkg = clazz.getPackage();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (JsonElement item : jsonArray.getAsJsonArray()) {
            Class currentClass = clazz;
            Class overridenClass = this.getClassFromJson(item, pkg);
            if (overridenClass != null) {
                currentClass = overridenClass;
            }
            Object deserializedItem = serializer.fromJson(item, currentClass);
            arrayList.add(deserializedItem);
        }
        return arrayList;
    }

    private void sanitizePostSerialization(JsonElement json) {
        block7: {
            block6: {
                if (!json.isJsonArray()) break block6;
                JsonArray jsonArray = json.getAsJsonArray();
                for (JsonElement subElement : jsonArray) {
                    this.sanitizePostSerialization(subElement);
                }
                break block7;
            }
            if (!json.isJsonObject()) break block7;
            JsonObject jsonObject = json.getAsJsonObject();
            HashSet entries = new HashSet(jsonObject.entrySet());
            for (Map.Entry entry : entries) {
                String propertyName = (String)entry.getKey();
                JsonElement subElement = (JsonElement)entry.getValue();
                String newName = propertyName;
                if (newName.startsWith("$$__$$")) {
                    newName = newName.substring("$$__$$".length());
                    if (Helpers.getReservedNames().contains(newName)) {
                        jsonObject.remove(newName);
                        jsonObject.add(propertyName, subElement);
                    }
                } else if (propertyName.equals("$$__ODataType")) {
                    jsonObject.remove("$$__ODataType");
                    jsonObject.add("@odata.type", subElement);
                }
                this.sanitizePostSerialization(subElement);
            }
        }
    }

    private void sanitizeForDeserialization(JsonElement json) {
        block6: {
            block5: {
                if (!json.isJsonArray()) break block5;
                JsonArray jsonArray = json.getAsJsonArray();
                for (JsonElement subElement : jsonArray) {
                    this.sanitizeForDeserialization(subElement);
                }
                break block6;
            }
            if (!json.isJsonObject()) break block6;
            JsonObject jsonObject = json.getAsJsonObject();
            HashSet entries = new HashSet(jsonObject.entrySet());
            for (Map.Entry entry : entries) {
                String propertyName = (String)entry.getKey();
                JsonElement subElement = (JsonElement)entry.getValue();
                String newName = "$$__$$" + propertyName;
                if (Helpers.getReservedNames().contains(propertyName)) {
                    jsonObject.remove(propertyName);
                    jsonObject.add(newName, subElement);
                } else {
                    String oDataTypeName = "$$__ODataType";
                    if (propertyName.equals("@odata.type")) {
                        jsonObject.remove(propertyName);
                        jsonObject.add(oDataTypeName, subElement);
                    }
                }
                this.sanitizePostSerialization(subElement);
            }
        }
    }
}

