/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.odata.impl.http;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.odata.impl.http.NetworkRunnable;
import com.microsoft.services.odata.impl.http.NetworkThread;
import com.microsoft.services.odata.impl.http.RequestImpl;
import com.microsoft.services.odata.interfaces.HttpTransport;
import com.microsoft.services.odata.interfaces.Request;
import com.microsoft.services.odata.interfaces.Response;

public abstract class BaseHttpTransport
implements HttpTransport {
    @Override
    public Request createRequest() {
        return new RequestImpl();
    }

    @Override
    public ListenableFuture<Response> execute(Request request) {
        SettableFuture future = SettableFuture.create();
        final NetworkRunnable target = this.createNetworkRunnable(request, (SettableFuture<Response>)future);
        final NetworkThread networkThread = new NetworkThread((Runnable)target){

            @Override
            public void releaseAndStop() {
                try {
                    target.closeStreamAndConnection();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Response>(){

            public void onFailure(Throwable t) {
                networkThread.releaseAndStop();
            }

            public void onSuccess(Response response) {
            }
        });
        networkThread.start();
        return future;
    }

    protected abstract NetworkRunnable createNetworkRunnable(Request var1, SettableFuture<Response> var2);
}

