/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public final class RClassBuilder {
    private Filer filer;
    private Messager messager;
    private HashMap<String, Integer> layoutNameAndIdMap = new LinkedHashMap<String, Integer>();
    private HashMap<String, Integer> viewNameAndIdMap = new LinkedHashMap<String, Integer>();
    private TypeSpec.Builder classBuilder;
    private TypeSpec.Builder layoutClassBuilder;
    private TypeSpec.Builder idClassBuilder;
    private ClassName className;
    private ClassName layoutClassName;
    private ClassName idClassName;

    private RClassBuilder(Filer filer, Messager messager, TypeSpec.Builder classBuilder, TypeSpec.Builder layoutClassBuilder, TypeSpec.Builder idClassBuilder, ClassName className, ClassName layoutClassName, ClassName idClassName, HashMap<String, Integer> layoutNameAndIdMap, HashMap<String, Integer> viewNameAndIdMap) {
        this.filer = filer;
        this.messager = messager;
        this.classBuilder = classBuilder;
        this.layoutClassBuilder = layoutClassBuilder;
        this.className = className;
        this.idClassBuilder = idClassBuilder;
        this.layoutClassName = layoutClassName;
        this.idClassName = idClassName;
        this.layoutNameAndIdMap = layoutNameAndIdMap;
        this.viewNameAndIdMap = viewNameAndIdMap;
    }

    public static RClassBuilder create(Filer filer, Messager messager) {
        ClassName className = ClassName.get((String)"com.mindorks.placeholderview.$", (String)"R", (String[])new String[0]);
        return new RClassBuilder(filer, messager, TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addComment("$S", new Object[]{"Not to be instantiated in public"}).build()), TypeSpec.classBuilder((String)"layout").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addComment("$S", new Object[]{"Not to be instantiated in public"}).build()), TypeSpec.classBuilder((String)"id").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addComment("$S", new Object[]{"Not to be instantiated in public"}).build()), className, ClassName.get((String)"com.mindorks.placeholderview.$", (String)"R", (String[])new String[]{"layout"}), ClassName.get((String)"com.mindorks.placeholderview.$", (String)"R", (String[])new String[]{"id"}), new HashMap<String, Integer>(), new HashMap<String, Integer>());
    }

    public String addLayoutId(TypeElement element, int layoutId) {
        int count = 0;
        String variable = element.getSimpleName().toString();
        while (this.layoutNameAndIdMap.containsKey(variable)) {
            if (this.layoutNameAndIdMap.get(variable) == layoutId) {
                return variable;
            }
            variable = variable + "_" + ++count;
        }
        this.layoutClassBuilder.addField(FieldSpec.builder(Integer.TYPE, (String)variable, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(new Modifier[]{Modifier.FINAL}).initializer("$L", new Object[]{layoutId}).build());
        this.layoutNameAndIdMap.put(variable, layoutId);
        return variable;
    }

    public String addViewId(Element element, int viewId) {
        int count = 0;
        String variable = element.getSimpleName().toString();
        while (this.viewNameAndIdMap.containsKey(variable)) {
            if (this.viewNameAndIdMap.get(variable) == viewId) {
                return variable;
            }
            variable = variable + "_" + ++count;
        }
        this.idClassBuilder.addField(FieldSpec.builder(Integer.TYPE, (String)variable, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(new Modifier[]{Modifier.FINAL}).initializer("$L", new Object[]{viewId}).build());
        this.viewNameAndIdMap.put(variable, viewId);
        return variable;
    }

    public TypeSpec build() {
        return this.classBuilder.addType(this.idClassBuilder.build()).addType(this.layoutClassBuilder.build()).build();
    }

    public ClassName getClassName() {
        return this.className;
    }

    public ClassName getLayoutClassName() {
        return this.layoutClassName;
    }

    public ClassName getIdClassName() {
        return this.idClassName;
    }
}

