/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview.compiler.core;

import com.squareup.javapoet.ClassName;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public class ClassDetail {
    private TypeElement typeElement;
    private String packageName;
    private String typeName;
    private ClassName className;
    private ClassName generatedClassName;
    private ClassName superClassName;
    private ClassName androidViewClassName;
    private ClassName androidOnClickListenerClassName;
    private ClassName androidOnLongClickListenerClassName;
    private ClassName frameViewClassName;
    private ClassName swipeOptionClassName;
    private ClassName swipeDirectionalOptionClassName;
    private ClassName swipeDecorClassName;
    private ClassName viewTypeParameterClassName;
    private ClassName swipeDirectionClassName;
    private List<VariableElement> variableElements;
    private List<ExecutableElement> executableElements;

    public ClassDetail(TypeElement typeElement, String packageName, String baseClassName, String generatedClassNameSuffix) {
        this.typeElement = typeElement;
        this.packageName = packageName;
        this.typeName = typeElement.getSimpleName().toString();
        this.className = ClassName.get((String)packageName, (String)this.typeName, (String[])new String[0]);
        this.generatedClassName = ClassName.get((String)packageName, (String)(this.typeName + generatedClassNameSuffix), (String[])new String[0]);
        this.superClassName = ClassName.get((String)"com.mindorks.placeholderview", (String)baseClassName, (String[])new String[0]);
        this.androidViewClassName = ClassName.get((String)"android.view", (String)"View", (String[])new String[0]);
        this.androidOnClickListenerClassName = ClassName.get((String)"android.view", (String)"View", (String[])new String[]{"OnClickListener"});
        this.androidOnLongClickListenerClassName = ClassName.get((String)"android.view", (String)"View", (String[])new String[]{"OnLongClickListener"});
        this.frameViewClassName = ClassName.get((String)"com.mindorks.placeholderview", (String)"SwipePlaceHolderView", (String[])new String[]{"FrameView"});
        this.swipeOptionClassName = ClassName.get((String)"com.mindorks.placeholderview", (String)"SwipePlaceHolderView", (String[])new String[]{"SwipeOption"});
        this.swipeDirectionalOptionClassName = ClassName.get((String)"com.mindorks.placeholderview", (String)"SwipeDirectionalView", (String[])new String[]{"SwipeDirectionalOption"});
        this.swipeDecorClassName = ClassName.get((String)"com.mindorks.placeholderview", (String)"SwipeDecor", (String[])new String[0]);
        this.swipeDirectionClassName = ClassName.get((String)"com.mindorks.placeholderview", (String)"SwipeDirection", (String[])new String[0]);
        this.viewTypeParameterClassName = this.androidViewClassName;
        this.variableElements = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        this.executableElements = ElementFilter.methodsIn(typeElement.getEnclosedElements());
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public ClassName getGeneratedClassName() {
        return this.generatedClassName;
    }

    public ClassName getSuperClassName() {
        return this.superClassName;
    }

    public ClassName getAndroidViewClassName() {
        return this.androidViewClassName;
    }

    public ClassName getAndroidOnClickListenerClassName() {
        return this.androidOnClickListenerClassName;
    }

    public ClassName getAndroidOnLongClickListenerClassName() {
        return this.androidOnLongClickListenerClassName;
    }

    public ClassName getFrameViewClassName() {
        return this.frameViewClassName;
    }

    public ClassName getSwipeOptionClassName() {
        return this.swipeOptionClassName;
    }

    public ClassName getSwipeDirectionalOptionClassName() {
        return this.swipeDirectionalOptionClassName;
    }

    public ClassName getSwipeDecorClassName() {
        return this.swipeDecorClassName;
    }

    public ClassName getViewTypeParameterClassName() {
        return this.viewTypeParameterClassName;
    }

    public void changeViewTypeParameterClassName(ClassName viewTypeParameterClassName) {
        this.viewTypeParameterClassName = viewTypeParameterClassName;
    }

    public ClassName getSwipeDirectionClassName() {
        return this.swipeDirectionClassName;
    }

    public List<VariableElement> getVariableElements() {
        return this.variableElements;
    }

    public List<ExecutableElement> getExecutableElements() {
        return this.executableElements;
    }
}

