/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview.compiler.structures;

import com.mindorks.placeholderview.annotations.Layout;
import com.mindorks.placeholderview.annotations.NonReusable;
import com.mindorks.placeholderview.annotations.expand.ChildPosition;
import com.mindorks.placeholderview.annotations.expand.Collapse;
import com.mindorks.placeholderview.annotations.expand.Expand;
import com.mindorks.placeholderview.annotations.expand.Parent;
import com.mindorks.placeholderview.annotations.expand.ParentPosition;
import com.mindorks.placeholderview.annotations.expand.SingleTop;
import com.mindorks.placeholderview.annotations.expand.Toggle;
import com.mindorks.placeholderview.compiler.RClassBuilder;
import com.mindorks.placeholderview.compiler.core.ClassDetail;
import com.mindorks.placeholderview.compiler.core.IllegalUseException;
import com.mindorks.placeholderview.compiler.core.Validator;
import com.mindorks.placeholderview.compiler.structures.ViewBinderClassStructure;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

public class ExpandableViewBinderClassStructure
extends ViewBinderClassStructure {
    public ExpandableViewBinderClassStructure(ClassDetail classDetail, RClassBuilder rClassBuilder) {
        super(classDetail, rClassBuilder);
    }

    public static ExpandableViewBinderClassStructure create(TypeElement typeElement, Elements elementUtils, RClassBuilder rClassBuilder) {
        String packageName = elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
        return new ExpandableViewBinderClassStructure(new ClassDetail(typeElement, packageName, "ExpandableViewBinder", "$ExpandableViewBinder"), rClassBuilder);
    }

    @Override
    public ExpandableViewBinderClassStructure addResolveViewMethod() throws IllegalUseException {
        return (ExpandableViewBinderClassStructure)super.addResolveViewMethod();
    }

    @Override
    public ExpandableViewBinderClassStructure addRecycleViewMethod() throws IllegalUseException {
        return (ExpandableViewBinderClassStructure)super.addRecycleViewMethod();
    }

    @Override
    public ExpandableViewBinderClassStructure addBindViewPositionMethod() throws IllegalUseException {
        return (ExpandableViewBinderClassStructure)super.addBindViewPositionMethod();
    }

    @Override
    public ExpandableViewBinderClassStructure addBindViewMethod() throws IllegalUseException {
        return (ExpandableViewBinderClassStructure)super.addBindViewMethod();
    }

    @Override
    public ExpandableViewBinderClassStructure addBindClickMethod() throws IllegalUseException {
        return (ExpandableViewBinderClassStructure)super.addBindClickMethod();
    }

    @Override
    public ExpandableViewBinderClassStructure addBindLongClickMethod() throws IllegalUseException {
        return (ExpandableViewBinderClassStructure)super.addBindLongClickMethod();
    }

    @Override
    public ExpandableViewBinderClassStructure addUnbindMethod() {
        this.getClassBuilder().addMethod(MethodSpec.methodBuilder((String)"unbind").addAnnotation(Deprecated.class).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).build());
        return this;
    }

    public ExpandableViewBinderClassStructure addBindAnimationMethod() {
        this.getClassBuilder().addMethod(MethodSpec.methodBuilder((String)"bindAnimation").addAnnotation(Deprecated.class).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(Integer.TYPE, "deviceWidth", new Modifier[0]).addParameter(Integer.TYPE, "deviceHeight", new Modifier[0]).addParameter((TypeName)this.getClassDetail().getAndroidViewClassName(), "view", new Modifier[0]).build());
        return this;
    }

    @Override
    public ExpandableViewBinderClassStructure addConstructor() {
        Layout layout = this.getClassDetail().getTypeElement().getAnnotation(Layout.class);
        NonReusable nonReusable = this.getClassDetail().getTypeElement().getAnnotation(NonReusable.class);
        Parent parentAnnotation = this.getClassDetail().getTypeElement().getAnnotation(Parent.class);
        SingleTop singleTopAnnotation = this.getClassDetail().getTypeElement().getAnnotation(SingleTop.class);
        boolean nullable = nonReusable != null;
        boolean parent = parentAnnotation != null && parentAnnotation.value();
        boolean singleTop = singleTopAnnotation != null && singleTopAnnotation.value();
        this.getClassBuilder().addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.getClassDetail().getClassName(), "resolver", new Modifier[0]).addStatement("super($N, $T.$L, $L, $L, $L)", new Object[]{"resolver", this.getRClassBuilder().getLayoutClassName(), this.getRClassBuilder().addLayoutId(this.getClassDetail().getTypeElement(), layout.value()), nullable, parent, singleTop}).build());
        return this;
    }

    public ExpandableViewBinderClassStructure addBindParentPositionMethod() throws IllegalUseException {
        MethodSpec.Builder bindParentPositionMethodBuilder = MethodSpec.methodBuilder((String)"bindParentPosition").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addParameter(Integer.TYPE, "position", new Modifier[0]);
        for (VariableElement variableElement : this.getClassDetail().getVariableElements()) {
            ParentPosition position = variableElement.getAnnotation(ParentPosition.class);
            if (position == null) continue;
            Validator.validatePosition(variableElement);
            bindParentPositionMethodBuilder.addStatement("$N().$N = $L", new Object[]{"getResolver", variableElement.getSimpleName(), "position"}).addStatement("$N($L)", new Object[]{"setParentPosition", "position"});
        }
        this.getClassBuilder().addMethod(bindParentPositionMethodBuilder.build());
        return this;
    }

    public ExpandableViewBinderClassStructure addBindChildPositionMethod() throws IllegalUseException {
        MethodSpec.Builder bindChildPositionMethodBuilder = MethodSpec.methodBuilder((String)"bindChildPosition").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addParameter(Integer.TYPE, "position", new Modifier[0]);
        for (VariableElement variableElement : this.getClassDetail().getVariableElements()) {
            ChildPosition position = variableElement.getAnnotation(ChildPosition.class);
            if (position == null) continue;
            Validator.validatePosition(variableElement);
            bindChildPositionMethodBuilder.addStatement("$N().$N = $L", new Object[]{"getResolver", variableElement.getSimpleName(), "position"}).addStatement("$N($L)", new Object[]{"setChildPosition", "position"});
        }
        this.getClassBuilder().addMethod(bindChildPositionMethodBuilder.build());
        return this;
    }

    public ExpandableViewBinderClassStructure addBindToggleMethod() throws IllegalUseException {
        MethodSpec.Builder bindToggleMethodBuilder = MethodSpec.methodBuilder((String)"bindToggle").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)this.getClassDetail().getClassName(), "resolver", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)this.getClassDetail().getAndroidViewClassName(), "itemView", new Modifier[0]).returns(Void.TYPE);
        TypeSpec OnClickListenerClass = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)this.getClassDetail().getAndroidOnClickListenerClassName()).addMethod(MethodSpec.methodBuilder((String)"onClick").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)this.getClassDetail().getAndroidViewClassName(), "view", new Modifier[0]).addStatement("if ($N()) $N()", new Object[]{"isExpanded", "collapse"}).addStatement("else $N()", new Object[]{"expand"}).returns(Void.TYPE).build()).build();
        int count = 0;
        for (VariableElement variableElement : this.getClassDetail().getVariableElements()) {
            Toggle toggle = variableElement.getAnnotation(Toggle.class);
            if (toggle == null) continue;
            if (count++ > 0) {
                throw new IllegalUseException("@Toggle can be used only on one view");
            }
            Validator.validateToggle(variableElement, toggle);
            bindToggleMethodBuilder.addStatement("$N.findViewById($T.$L).setOnClickListener($L)", new Object[]{"itemView", this.getRClassBuilder().getIdClassName(), this.getRClassBuilder().addViewId(variableElement, toggle.value()), OnClickListenerClass});
        }
        if (count == 0) {
            bindToggleMethodBuilder.addStatement("$N.setOnClickListener($L)", new Object[]{"itemView", OnClickListenerClass});
        }
        this.getClassBuilder().addMethod(bindToggleMethodBuilder.build());
        return this;
    }

    public ExpandableViewBinderClassStructure addBindExpandMethod() throws IllegalUseException {
        MethodSpec.Builder bindExpandMethodBuilder = MethodSpec.methodBuilder((String)"bindExpand").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addParameter((TypeName)this.getClassDetail().getClassName(), "resolver", new Modifier[0]);
        for (ExecutableElement executableElement : this.getClassDetail().getExecutableElements()) {
            Expand expand = executableElement.getAnnotation(Expand.class);
            if (expand == null) continue;
            Validator.validateExpand(executableElement);
            bindExpandMethodBuilder.addStatement("$N.$N()", new Object[]{"resolver", executableElement.getSimpleName()});
        }
        this.getClassBuilder().addMethod(bindExpandMethodBuilder.build());
        return this;
    }

    public ExpandableViewBinderClassStructure addBindCollapseMethod() throws IllegalUseException {
        MethodSpec.Builder bindCollapseMethodBuilder = MethodSpec.methodBuilder((String)"bindCollapse").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addParameter((TypeName)this.getClassDetail().getClassName(), "resolver", new Modifier[0]);
        for (ExecutableElement executableElement : this.getClassDetail().getExecutableElements()) {
            Collapse collapse = executableElement.getAnnotation(Collapse.class);
            if (collapse == null) continue;
            Validator.validateCollapse(executableElement);
            bindCollapseMethodBuilder.addStatement("$N.$N()", new Object[]{"resolver", executableElement.getSimpleName()});
        }
        this.getClassBuilder().addMethod(bindCollapseMethodBuilder.build());
        return this;
    }
}

