/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview.compiler.structures;

import com.mindorks.placeholderview.annotations.Click;
import com.mindorks.placeholderview.annotations.Layout;
import com.mindorks.placeholderview.annotations.LongClick;
import com.mindorks.placeholderview.annotations.NonReusable;
import com.mindorks.placeholderview.annotations.Position;
import com.mindorks.placeholderview.annotations.Recycle;
import com.mindorks.placeholderview.annotations.Resolve;
import com.mindorks.placeholderview.annotations.View;
import com.mindorks.placeholderview.compiler.RClassBuilder;
import com.mindorks.placeholderview.compiler.core.ClassDetail;
import com.mindorks.placeholderview.compiler.core.ClassStructure;
import com.mindorks.placeholderview.compiler.core.IllegalUseException;
import com.mindorks.placeholderview.compiler.core.Validator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class ViewBinderClassStructure
extends ClassStructure {
    private RClassBuilder rClassBuilder;

    public ViewBinderClassStructure(ClassDetail classDetail, RClassBuilder rClassBuilder) {
        super(classDetail);
        this.rClassBuilder = rClassBuilder;
    }

    public static ViewBinderClassStructure create(TypeElement typeElement, Elements elementUtils, RClassBuilder rClassBuilder) {
        String packageName = elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
        return new ViewBinderClassStructure(new ClassDetail(typeElement, packageName, "ViewBinder", "$ViewBinder"), rClassBuilder);
    }

    @Override
    protected TypeSpec.Builder createClassBuilder() {
        return TypeSpec.classBuilder((ClassName)this.getClassDetail().getGeneratedClassName()).superclass((TypeName)ParameterizedTypeName.get((ClassName)this.getClassDetail().getSuperClassName(), (TypeName[])new TypeName[]{TypeVariableName.get((TypeMirror)this.getClassDetail().getTypeElement().asType()), TypeVariableName.get((String)this.getClassDetail().getViewTypeParameterClassName().simpleName())})).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public ViewBinderClassStructure addConstructor() {
        Layout layout = this.getClassDetail().getTypeElement().getAnnotation(Layout.class);
        NonReusable nonReusable = this.getClassDetail().getTypeElement().getAnnotation(NonReusable.class);
        boolean nullable = nonReusable != null;
        this.getClassBuilder().addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.getClassDetail().getClassName(), "resolver", new Modifier[0]).addStatement("super($N, $T.$L, $L)", new Object[]{"resolver", this.getRClassBuilder().getLayoutClassName(), this.getRClassBuilder().addLayoutId(this.getClassDetail().getTypeElement(), layout.value()), nullable}).build());
        return this;
    }

    public ViewBinderClassStructure addResolveViewMethod() throws IllegalUseException {
        MethodSpec.Builder bindResolveMethodBuilder = MethodSpec.methodBuilder((String)"resolveView").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addParameter((TypeName)this.getClassDetail().getClassName(), "resolver", new Modifier[0]);
        for (ExecutableElement executableElement : this.getClassDetail().getExecutableElements()) {
            Resolve resolve = executableElement.getAnnotation(Resolve.class);
            if (resolve == null) continue;
            Validator.validateResolve(executableElement);
            bindResolveMethodBuilder.addStatement("$N.$N()", new Object[]{"resolver", executableElement.getSimpleName()});
        }
        this.getClassBuilder().addMethod(bindResolveMethodBuilder.build());
        return this;
    }

    public ViewBinderClassStructure addRecycleViewMethod() throws IllegalUseException {
        MethodSpec.Builder bindRecycleMethodBuilder = MethodSpec.methodBuilder((String)"recycleView").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addStatement("$T $N = $N()", new Object[]{this.getClassDetail().getClassName(), "resolver", "getResolver"}).returns(Void.TYPE);
        for (ExecutableElement executableElement : this.getClassDetail().getExecutableElements()) {
            Recycle recycle = executableElement.getAnnotation(Recycle.class);
            if (recycle == null) continue;
            Validator.validateRecycle(executableElement);
            bindRecycleMethodBuilder.addStatement("$N.$N()", new Object[]{"resolver", executableElement.getSimpleName()});
        }
        this.getClassBuilder().addMethod(bindRecycleMethodBuilder.build());
        return this;
    }

    public ViewBinderClassStructure addBindViewPositionMethod() throws IllegalUseException {
        MethodSpec.Builder bindViewPositionMethodBuilder = MethodSpec.methodBuilder((String)"bindViewPosition").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addParameter((TypeName)this.getClassDetail().getClassName(), "resolver", new Modifier[0]).addParameter(Integer.TYPE, "position", new Modifier[0]);
        for (VariableElement variableElement : this.getClassDetail().getVariableElements()) {
            Position position = variableElement.getAnnotation(Position.class);
            if (position == null) continue;
            Validator.validatePosition(variableElement);
            bindViewPositionMethodBuilder.addStatement("$N.$N = $L", new Object[]{"resolver", variableElement.getSimpleName(), "position"});
        }
        this.getClassBuilder().addMethod(bindViewPositionMethodBuilder.build());
        return this;
    }

    public ViewBinderClassStructure addBindViewMethod() throws IllegalUseException {
        MethodSpec.Builder bindViewMethodBuilder = MethodSpec.methodBuilder((String)"bindViews").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addParameter((TypeName)this.getClassDetail().getClassName(), "resolver", new Modifier[0]).addParameter((TypeName)this.getClassDetail().getViewTypeParameterClassName(), "itemView", new Modifier[0]);
        for (VariableElement variableElement : this.getClassDetail().getVariableElements()) {
            View view = variableElement.getAnnotation(View.class);
            if (view == null) continue;
            Validator.validateView(variableElement, view);
            bindViewMethodBuilder.addStatement("$N.$N = ($T)$N.findViewById($T.$L)", new Object[]{"resolver", variableElement.getSimpleName(), variableElement, "itemView", this.getRClassBuilder().getIdClassName(), this.getRClassBuilder().addViewId(variableElement, view.value())});
        }
        this.getClassBuilder().addMethod(bindViewMethodBuilder.build());
        return this;
    }

    public ViewBinderClassStructure addBindClickMethod() throws IllegalUseException {
        MethodSpec.Builder bindClickMethodBuilder = MethodSpec.methodBuilder((String)"bindClick").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addParameter((TypeName)this.getClassDetail().getClassName(), "resolver", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)this.getClassDetail().getViewTypeParameterClassName(), "itemView", new Modifier[0]);
        for (ExecutableElement executableElement : this.getClassDetail().getExecutableElements()) {
            Click click = executableElement.getAnnotation(Click.class);
            if (click == null) continue;
            Validator.validateClick(executableElement, click);
            TypeSpec OnClickListenerClass = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)this.getClassDetail().getAndroidOnClickListenerClassName()).addMethod(MethodSpec.methodBuilder((String)"onClick").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)this.getClassDetail().getAndroidViewClassName(), "view", new Modifier[0]).addStatement("$N.$N()", new Object[]{"resolver", executableElement.getSimpleName()}).returns(Void.TYPE).build()).build();
            bindClickMethodBuilder.addStatement("$N.findViewById($T.$L).setOnClickListener($L)", new Object[]{"itemView", this.getRClassBuilder().getIdClassName(), this.getRClassBuilder().addViewId(executableElement, click.value()), OnClickListenerClass});
        }
        this.getClassBuilder().addMethod(bindClickMethodBuilder.build());
        return this;
    }

    public ViewBinderClassStructure addBindLongClickMethod() throws IllegalUseException {
        MethodSpec.Builder bindLongClickMethodBuilder = MethodSpec.methodBuilder((String)"bindLongClick").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addParameter((TypeName)this.getClassDetail().getClassName(), "resolver", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)this.getClassDetail().getViewTypeParameterClassName(), "itemView", new Modifier[0]);
        for (ExecutableElement executableElement : this.getClassDetail().getExecutableElements()) {
            LongClick longClick = executableElement.getAnnotation(LongClick.class);
            if (longClick == null) continue;
            Validator.validateLongClick(executableElement, longClick);
            TypeSpec OnClickListenerClass = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)this.getClassDetail().getAndroidOnLongClickListenerClassName()).addMethod(MethodSpec.methodBuilder((String)"onLongClick").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)this.getClassDetail().getAndroidViewClassName(), "view", new Modifier[0]).addStatement("$N.$N()", new Object[]{"resolver", executableElement.getSimpleName()}).addStatement("$N $L", new Object[]{"return", true}).returns(Boolean.TYPE).build()).build();
            bindLongClickMethodBuilder.addStatement("$N.findViewById($T.$L).setOnLongClickListener($L)", new Object[]{"itemView", this.getRClassBuilder().getIdClassName(), this.getRClassBuilder().addViewId(executableElement, longClick.value()), OnClickListenerClass});
        }
        this.getClassBuilder().addMethod(bindLongClickMethodBuilder.build());
        return this;
    }

    public ViewBinderClassStructure addUnbindMethod() {
        MethodSpec.Builder unbindMethodBuilder = MethodSpec.methodBuilder((String)"unbind").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addStatement("$T $N = $N()", new Object[]{this.getClassDetail().getClassName(), "resolver", "getResolver"}).addStatement("$L $N = $N()", new Object[]{Boolean.TYPE, "nullable", "isNullable"}).beginControlFlow("if ($N != $L && $N)", new Object[]{"resolver", null, "nullable"});
        for (VariableElement variableElement : this.getClassDetail().getVariableElements()) {
            if (variableElement.asType().getKind().isPrimitive() || variableElement.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            unbindMethodBuilder.addStatement("$N.$N = $L", new Object[]{"resolver", variableElement.getSimpleName(), null});
        }
        unbindMethodBuilder.addStatement("$N($L)", new Object[]{"setResolver", null}).addStatement("$N($L)", new Object[]{"setAnimationResolver", null}).endControlFlow().returns(Void.TYPE);
        this.getClassBuilder().addMethod(unbindMethodBuilder.build());
        return this;
    }

    public RClassBuilder getRClassBuilder() {
        return this.rClassBuilder;
    }
}

