/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.flurry.android.FlurryAgent;
import com.flurry.android.FlurryAgentListener;

public final class FlurryAgentWrapper {
    public static final String PARAM_API_KEY = "apiKey";
    public static final String PARAM_AD_SPACE_NAME = "adSpaceName";
    private static final String ORIGIN_IDENTIFIER = "Flurry_Mopub_Android";
    private static final String ORIGIN_VERSION = "6.5.0";
    private FlurryAgent.Builder mAgentBuilder = new FlurryAgent.Builder().withLogEnabled(false).withLogLevel(4);

    public static FlurryAgentWrapper getInstance() {
        return FlurryAgentLoader.INSTANCE;
    }

    private FlurryAgentWrapper() {
        FlurryAgent.addOrigin((String)ORIGIN_IDENTIFIER, (String)ORIGIN_VERSION);
    }

    public synchronized void startSession(@NonNull Context context, String apiKey, @Nullable FlurryAgentListener flurryAgentListener) {
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            return;
        }
        if (!FlurryAgent.isSessionActive()) {
            this.mAgentBuilder.withListener(flurryAgentListener).build(context, apiKey);
            if (Build.VERSION.SDK_INT >= 14) {
                return;
            }
            FlurryAgent.onStartSession((Context)context);
        }
    }

    public synchronized void endSession(Context context) {
        if (context == null) {
            return;
        }
        if (FlurryAgent.isSessionActive()) {
            if (Build.VERSION.SDK_INT >= 14) {
                return;
            }
            FlurryAgent.onEndSession((Context)context);
        }
    }

    public synchronized boolean isSessionActive() {
        return FlurryAgent.isSessionActive();
    }

    private static class FlurryAgentLoader {
        private static final FlurryAgentWrapper INSTANCE = new FlurryAgentWrapper();

        private FlurryAgentLoader() {
        }
    }
}

