/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.flurry.android.ads.FlurryAdErrorType;
import com.flurry.android.ads.FlurryAdInterstitial;
import com.flurry.android.ads.FlurryAdInterstitialListener;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.FlurryAgentWrapper;
import com.mopub.mobileads.MoPubErrorCode;
import java.util.Map;

class FlurryCustomEventInterstitial
extends CustomEventInterstitial {
    private static final String LOG_TAG = FlurryCustomEventInterstitial.class.getSimpleName();
    private Context mContext;
    private CustomEventInterstitial.CustomEventInterstitialListener mListener;
    private String mAdSpaceName;
    private FlurryAdInterstitial mInterstitial;

    FlurryCustomEventInterstitial() {
    }

    protected void loadInterstitial(Context context, CustomEventInterstitial.CustomEventInterstitialListener listener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        if (context == null) {
            Log.e((String)LOG_TAG, (String)"Context cannot be null.");
            listener.onInterstitialFailed(MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        if (listener == null) {
            Log.e((String)LOG_TAG, (String)"CustomEventInterstitialListener cannot be null.");
            return;
        }
        if (!(context instanceof Activity)) {
            Log.e((String)LOG_TAG, (String)"Ad can be rendered only in Activity context.");
            listener.onInterstitialFailed(MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        if (!this.validateExtras(serverExtras)) {
            Log.e((String)LOG_TAG, (String)"Failed interstitial ad fetch: Missing required server extras [FLURRY_APIKEY and/or FLURRY_ADSPACE].");
            listener.onInterstitialFailed(MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        this.setAutomaticImpressionAndClickTracking(false);
        this.mContext = context;
        this.mListener = listener;
        String apiKey = serverExtras.get("apiKey");
        this.mAdSpaceName = serverExtras.get("adSpaceName");
        FlurryAgentWrapper.getInstance().startSession(context, apiKey, null);
        Log.d((String)LOG_TAG, (String)("Fetching Flurry ad, ad unit name:" + this.mAdSpaceName));
        this.mInterstitial = new FlurryAdInterstitial(this.mContext, this.mAdSpaceName);
        this.mInterstitial.setListener((FlurryAdInterstitialListener)new FlurryMopubInterstitialListener());
        this.mInterstitial.fetchAd();
    }

    protected void onInvalidate() {
        if (this.mContext == null) {
            return;
        }
        Log.d((String)LOG_TAG, (String)("MoPub issued onInvalidate (" + this.mAdSpaceName + ")"));
        if (this.mInterstitial != null) {
            this.mInterstitial.destroy();
            this.mInterstitial = null;
        }
        FlurryAgentWrapper.getInstance().endSession(this.mContext);
        this.mContext = null;
        this.mListener = null;
    }

    protected void showInterstitial() {
        Log.d((String)LOG_TAG, (String)("MoPub issued showInterstitial (" + this.mAdSpaceName + ")"));
        if (this.mInterstitial != null) {
            this.mInterstitial.displayAd();
        }
    }

    private boolean validateExtras(Map<String, String> serverExtras) {
        if (serverExtras == null) {
            return false;
        }
        String flurryApiKey = serverExtras.get("apiKey");
        String flurryAdSpace = serverExtras.get("adSpaceName");
        Log.i((String)LOG_TAG, (String)("ServerInfo fetched from Mopub apiKey : " + flurryApiKey + " and " + "adSpaceName" + " :" + flurryAdSpace));
        return !TextUtils.isEmpty((CharSequence)flurryApiKey) && !TextUtils.isEmpty((CharSequence)flurryAdSpace);
    }

    private class FlurryMopubInterstitialListener
    implements FlurryAdInterstitialListener {
        private final String LOG_TAG = this.getClass().getSimpleName();

        private FlurryMopubInterstitialListener() {
        }

        public void onFetched(FlurryAdInterstitial adInterstitial) {
            Log.d((String)this.LOG_TAG, (String)"onFetched: Flurry interstitial ad fetched successfully!");
            if (FlurryCustomEventInterstitial.this.mListener != null) {
                FlurryCustomEventInterstitial.this.mListener.onInterstitialLoaded();
            }
        }

        public void onRendered(FlurryAdInterstitial adInterstitial) {
            Log.d((String)this.LOG_TAG, (String)"onRendered: Flurry interstitial ad rendered");
            if (FlurryCustomEventInterstitial.this.mListener != null) {
                FlurryCustomEventInterstitial.this.mListener.onInterstitialShown();
            }
        }

        public void onDisplay(FlurryAdInterstitial adInterstitial) {
            Log.d((String)this.LOG_TAG, (String)"onDisplay: Flurry interstitial ad displayed");
            if (FlurryCustomEventInterstitial.this.mListener != null) {
                FlurryCustomEventInterstitial.this.mListener.onInterstitialImpression();
            }
        }

        public void onClose(FlurryAdInterstitial adInterstitial) {
            Log.d((String)this.LOG_TAG, (String)"onClose: Flurry interstitial ad closed");
            if (FlurryCustomEventInterstitial.this.mListener != null) {
                FlurryCustomEventInterstitial.this.mListener.onInterstitialDismissed();
            }
        }

        public void onAppExit(FlurryAdInterstitial adInterstitial) {
            Log.d((String)this.LOG_TAG, (String)"onAppExit: Flurry interstitial ad exited app");
        }

        public void onClicked(FlurryAdInterstitial adInterstitial) {
            Log.d((String)this.LOG_TAG, (String)"onClicked: Flurry interstitial ad clicked");
            if (FlurryCustomEventInterstitial.this.mListener != null) {
                FlurryCustomEventInterstitial.this.mListener.onInterstitialClicked();
            }
        }

        public void onVideoCompleted(FlurryAdInterstitial adInterstitial) {
            Log.d((String)this.LOG_TAG, (String)"onVideoCompleted: Flurry interstitial ad video completed");
        }

        public void onError(FlurryAdInterstitial adInterstitial, FlurryAdErrorType adErrorType, int errorCode) {
            Log.d((String)this.LOG_TAG, (String)String.format("onError: Flurry interstitial ad not available. Error type: %s. Error code: %s", adErrorType.toString(), errorCode));
            if (FlurryCustomEventInterstitial.this.mListener != null) {
                switch (adErrorType) {
                    case FETCH: {
                        FlurryCustomEventInterstitial.this.mListener.onInterstitialFailed(MoPubErrorCode.NETWORK_NO_FILL);
                        return;
                    }
                    case RENDER: {
                        FlurryCustomEventInterstitial.this.mListener.onInterstitialFailed(MoPubErrorCode.NETWORK_INVALID_STATE);
                        return;
                    }
                    case CLICK: {
                        return;
                    }
                }
                FlurryCustomEventInterstitial.this.mListener.onInterstitialFailed(MoPubErrorCode.UNSPECIFIED);
            }
        }
    }
}

